package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;


/**
 * The input and output payload for the RPC Benchmark's Global RPC Server (a list 
 * of integers)
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * list payload {
 *     key "id"
 *     leaf id {
 *         type int32;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbench-payload/payload/payload</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadBuilder}.
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadBuilder
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadKey
 *
 */
public interface Payload
    extends
    ChildOf<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload>,
    Augmentable<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>,
    Identifiable<PayloadKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("rpcbench-payload",
        "2015-07-02", "payload").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>id</code>, or <code>null</code> if not present
     */
    java.lang.Integer getId();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadKey</code> <code>key</code>, or <code>null</code> if not present
     */
    PayloadKey getKey();

}

