package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;


/**
 * Routed RPC server context instances (i.e. instances to which RPC calls are 
 * routed)
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * list rpc-route {
 *     key "id"
 *     leaf id {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbench-payload/rpcbench-rpc-routes/rpc-route</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteBuilder}.
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteBuilder
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteKey
 *
 */
public interface RpcRoute
    extends
    ChildOf<RpcbenchRpcRoutes>,
    Augmentable<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute>,
    Identifiable<RpcRouteKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("rpcbench-payload",
        "2015-07-02", "rpc-route").intern();

    /**
     * @return <code>java.lang.String</code> <code>id</code>, or <code>null</code> if not present
     */
    java.lang.String getId();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteKey</code> <code>key</code>, or <code>null</code> if not present
     */
    RpcRouteKey getKey();

}

