package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.TransactionType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataFormat;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.Operation;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * container input {
 *     leaf operation {
 *         type enumeration;
 *     }
 *     leaf data-format {
 *         type enumeration;
 *     }
 *     leaf transaction-type {
 *         type enumeration;
 *     }
 *     leaf data-store {
 *         type enumeration;
 *     }
 *     leaf outerElements {
 *         type outerElements;
 *     }
 *     leaf innerElements {
 *         type innerElements;
 *     }
 *     leaf putsPerTx {
 *         type putsPerTx;
 *     }
 *     leaf listeners {
 *         type listeners;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>dsbenchmark/start-test/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInputBuilder
 *
 */
public interface StartTestInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>
{


    public enum Operation {
        /**
         * The put operation
         *
         */
        PUT(1, "PUT"),
        
        /**
         * The merge operation
         *
         */
        MERGE(2, "MERGE"),
        
        /**
         * Delete items from a list sotred in the data store
         *
         */
        DELETE(3, "DELETE"),
        
        /**
         * The read operation
         *
         */
        READ(4, "READ")
        ;
    
    
        java.lang.String name;
        int value;
        private static final java.util.Map<java.lang.Integer, Operation> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Operation> b = com.google.common.collect.ImmutableMap.builder();
            for (Operation enumItem : Operation.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private Operation(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding Operation item
         */
        public static Operation forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }
    
    public enum DataFormat {
        BINDINGAWARE(1, "BINDING-AWARE"),
        
        BINDINGINDEPENDENT(2, "BINDING-INDEPENDENT")
        ;
    
    
        java.lang.String name;
        int value;
        private static final java.util.Map<java.lang.Integer, DataFormat> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, DataFormat> b = com.google.common.collect.ImmutableMap.builder();
            for (DataFormat enumItem : DataFormat.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private DataFormat(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding DataFormat item
         */
        public static DataFormat forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }
    
    public enum TransactionType {
        SIMPLETX(1, "SIMPLE-TX"),
        
        TXCHAINING(2, "TX-CHAINING")
        ;
    
    
        java.lang.String name;
        int value;
        private static final java.util.Map<java.lang.Integer, TransactionType> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, TransactionType> b = com.google.common.collect.ImmutableMap.builder();
            for (TransactionType enumItem : TransactionType.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private TransactionType(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding TransactionType item
         */
        public static TransactionType forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }
    
    public enum DataStore {
        CONFIG(1, "CONFIG"),
        
        OPERATIONAL(2, "OPERATIONAL"),
        
        BOTH(3, "BOTH")
        ;
    
    
        java.lang.String name;
        int value;
        private static final java.util.Map<java.lang.Integer, DataStore> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, DataStore> b = com.google.common.collect.ImmutableMap.builder();
            for (DataStore enumItem : DataStore.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private DataStore(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding DataStore item
         */
        public static DataStore forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:dsbenchmark",
        "2015-01-05", "input").intern();

    /**
     * Type of the transaction operation to benchmark
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.Operation</code> <code>operation</code>, or <code>null</code> if not present
     */
    Operation getOperation();
    
    /**
     * Data format:-binding-aware or binding-independent
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataFormat</code> <code>dataFormat</code>, or <code>null</code> if not present
     */
    DataFormat getDataFormat();
    
    /**
     * Data format:-binding-aware or binding-independent
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.TransactionType</code> <code>transactionType</code>, or <code>null</code> if not present
     */
    TransactionType getTransactionType();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataStore</code> <code>dataStore</code>, or <code>null</code> if not present
     */
    DataStore getDataStore();
    
    /**
     * Number of elements in the OuterList
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>outerElements</code>, or <code>null</code> if not present
     */
    java.lang.Long getOuterElements();
    
    /**
     * Number of elements in the InnerList
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>innerElements</code>, or <code>null</code> if not present
     */
    java.lang.Long getInnerElements();
    
    /**
     * Number of write operations (PUT, MERGE, or DELETE) per transaction submit
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>putsPerTx</code>, or <code>null</code> if not present
     */
    java.lang.Long getPutsPerTx();
    
    /**
     * Number of data tree change listeners listening for changes on the test exec 
     * tree.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>listeners</code>, or <code>null</code> if not present
     */
    java.lang.Long getListeners();

}

