package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.TransactionType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataFormat;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.Operation;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput
 *
 */
public class StartTestInputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> {

    private DataFormat _dataFormat;
    private DataStore _dataStore;
    private java.lang.Long _innerElements;
    private java.lang.Long _listeners;
    private Operation _operation;
    private java.lang.Long _outerElements;
    private java.lang.Long _putsPerTx;
    private TransactionType _transactionType;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentation = Collections.emptyMap();

    public StartTestInputBuilder() {
    }

    public StartTestInputBuilder(StartTestInput base) {
        this._dataFormat = base.getDataFormat();
        this._dataStore = base.getDataStore();
        this._innerElements = base.getInnerElements();
        this._listeners = base.getListeners();
        this._operation = base.getOperation();
        this._outerElements = base.getOuterElements();
        this._putsPerTx = base.getPutsPerTx();
        this._transactionType = base.getTransactionType();
        if (base instanceof StartTestInputImpl) {
            StartTestInputImpl impl = (StartTestInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public DataFormat getDataFormat() {
        return _dataFormat;
    }
    
    public DataStore getDataStore() {
        return _dataStore;
    }
    
    public java.lang.Long getInnerElements() {
        return _innerElements;
    }
    
    public java.lang.Long getListeners() {
        return _listeners;
    }
    
    public Operation getOperation() {
        return _operation;
    }
    
    public java.lang.Long getOuterElements() {
        return _outerElements;
    }
    
    public java.lang.Long getPutsPerTx() {
        return _putsPerTx;
    }
    
    public TransactionType getTransactionType() {
        return _transactionType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public StartTestInputBuilder setDataFormat(final DataFormat value) {
        this._dataFormat = value;
        return this;
    }
    
     
    public StartTestInputBuilder setDataStore(final DataStore value) {
        this._dataStore = value;
        return this;
    }
    
     
     private static void checkInnerElementsRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestInputBuilder setInnerElements(final java.lang.Long value) {
    if (value != null) {
        checkInnerElementsRange(value);
    }
        this._innerElements = value;
        return this;
    }
    
     
     private static void checkListenersRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestInputBuilder setListeners(final java.lang.Long value) {
    if (value != null) {
        checkListenersRange(value);
    }
        this._listeners = value;
        return this;
    }
    
     
    public StartTestInputBuilder setOperation(final Operation value) {
        this._operation = value;
        return this;
    }
    
     
     private static void checkOuterElementsRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestInputBuilder setOuterElements(final java.lang.Long value) {
    if (value != null) {
        checkOuterElementsRange(value);
    }
        this._outerElements = value;
        return this;
    }
    
     
     private static void checkPutsPerTxRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestInputBuilder setPutsPerTx(final java.lang.Long value) {
    if (value != null) {
        checkPutsPerTxRange(value);
    }
        this._putsPerTx = value;
        return this;
    }
    
     
    public StartTestInputBuilder setTransactionType(final TransactionType value) {
        this._transactionType = value;
        return this;
    }
    
    public StartTestInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public StartTestInputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestInput build() {
        return new StartTestInputImpl(this);
    }

    private static final class StartTestInputImpl implements StartTestInput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.class;
        }

        private final DataFormat _dataFormat;
        private final DataStore _dataStore;
        private final java.lang.Long _innerElements;
        private final java.lang.Long _listeners;
        private final Operation _operation;
        private final java.lang.Long _outerElements;
        private final java.lang.Long _putsPerTx;
        private final TransactionType _transactionType;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentation = Collections.emptyMap();

        private StartTestInputImpl(StartTestInputBuilder base) {
            this._dataFormat = base.getDataFormat();
            this._dataStore = base.getDataStore();
            this._innerElements = base.getInnerElements();
            this._listeners = base.getListeners();
            this._operation = base.getOperation();
            this._outerElements = base.getOuterElements();
            this._putsPerTx = base.getPutsPerTx();
            this._transactionType = base.getTransactionType();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public DataFormat getDataFormat() {
            return _dataFormat;
        }
        
        @Override
        public DataStore getDataStore() {
            return _dataStore;
        }
        
        @Override
        public java.lang.Long getInnerElements() {
            return _innerElements;
        }
        
        @Override
        public java.lang.Long getListeners() {
            return _listeners;
        }
        
        @Override
        public Operation getOperation() {
            return _operation;
        }
        
        @Override
        public java.lang.Long getOuterElements() {
            return _outerElements;
        }
        
        @Override
        public java.lang.Long getPutsPerTx() {
            return _putsPerTx;
        }
        
        @Override
        public TransactionType getTransactionType() {
            return _transactionType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataFormat);
            result = prime * result + Objects.hashCode(_dataStore);
            result = prime * result + Objects.hashCode(_innerElements);
            result = prime * result + Objects.hashCode(_listeners);
            result = prime * result + Objects.hashCode(_operation);
            result = prime * result + Objects.hashCode(_outerElements);
            result = prime * result + Objects.hashCode(_putsPerTx);
            result = prime * result + Objects.hashCode(_transactionType);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput)obj;
            if (!Objects.equals(_dataFormat, other.getDataFormat())) {
                return false;
            }
            if (!Objects.equals(_dataStore, other.getDataStore())) {
                return false;
            }
            if (!Objects.equals(_innerElements, other.getInnerElements())) {
                return false;
            }
            if (!Objects.equals(_listeners, other.getListeners())) {
                return false;
            }
            if (!Objects.equals(_operation, other.getOperation())) {
                return false;
            }
            if (!Objects.equals(_outerElements, other.getOuterElements())) {
                return false;
            }
            if (!Objects.equals(_putsPerTx, other.getPutsPerTx())) {
                return false;
            }
            if (!Objects.equals(_transactionType, other.getTransactionType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                StartTestInputImpl otherImpl = (StartTestInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "StartTestInput [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_dataFormat != null) {
                builder.append("_dataFormat=");
                builder.append(_dataFormat);
                builder.append(", ");
            }
            if (_dataStore != null) {
                builder.append("_dataStore=");
                builder.append(_dataStore);
                builder.append(", ");
            }
            if (_innerElements != null) {
                builder.append("_innerElements=");
                builder.append(_innerElements);
                builder.append(", ");
            }
            if (_listeners != null) {
                builder.append("_listeners=");
                builder.append(_listeners);
                builder.append(", ");
            }
            if (_operation != null) {
                builder.append("_operation=");
                builder.append(_operation);
                builder.append(", ");
            }
            if (_outerElements != null) {
                builder.append("_outerElements=");
                builder.append(_outerElements);
                builder.append(", ");
            }
            if (_putsPerTx != null) {
                builder.append("_putsPerTx=");
                builder.append(_putsPerTx);
                builder.append(", ");
            }
            if (_transactionType != null) {
                builder.append("_transactionType=");
                builder.append(_transactionType);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
