package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput.Status;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * container output {
 *     leaf status {
 *         type enumeration;
 *     }
 *     leaf listBuildTime {
 *         type listBuildTime;
 *     }
 *     leaf execTime {
 *         type execTime;
 *     }
 *     leaf txOk {
 *         type uint32;
 *     }
 *     leaf txError {
 *         type uint32;
 *     }
 *     leaf ntfOk {
 *         type uint32;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>dsbenchmark/start-test/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutputBuilder
 *
 */
public interface StartTestOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>
{


    public enum Status {
        OK(1, "OK"),
        
        FAILED(2, "FAILED"),
        
        TESTINPROGRESS(3, "TEST-IN-PROGRESS")
        ;
    
    
        java.lang.String name;
        int value;
        private static final java.util.Map<java.lang.Integer, Status> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Status> b = com.google.common.collect.ImmutableMap.builder();
            for (Status enumItem : Status.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private Status(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding Status item
         */
        public static Status forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:dsbenchmark",
        "2015-01-05", "output").intern();

    /**
     * Indicates whether the test finished successfuly
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput.Status</code> <code>status</code>, or <code>null</code> if not present
     */
    Status getStatus();
    
    /**
     * The time it took to build the list of lists
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>listBuildTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getListBuildTime();
    
    /**
     * The time it took to execute all transactions
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>execTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getExecTime();
    
    /**
     * The number of successful transactions
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>txOk</code>, or <code>null</code> if not present
     */
    java.lang.Long getTxOk();
    
    /**
     * The number of failed transactions
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>txError</code>, or <code>null</code> if not present
     */
    java.lang.Long getTxError();
    
    /**
     * The number of successfully received data tree change notifications
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>ntfOk</code>, or <code>null</code> if not present
     */
    java.lang.Long getNtfOk();

}

