package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput.Status;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput
 *
 */
public class StartTestOutputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput> {

    private java.lang.Long _execTime;
    private java.lang.Long _listBuildTime;
    private java.lang.Long _ntfOk;
    private Status _status;
    private java.lang.Long _txError;
    private java.lang.Long _txOk;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> augmentation = Collections.emptyMap();

    public StartTestOutputBuilder() {
    }

    public StartTestOutputBuilder(StartTestOutput base) {
        this._execTime = base.getExecTime();
        this._listBuildTime = base.getListBuildTime();
        this._ntfOk = base.getNtfOk();
        this._status = base.getStatus();
        this._txError = base.getTxError();
        this._txOk = base.getTxOk();
        if (base instanceof StartTestOutputImpl) {
            StartTestOutputImpl impl = (StartTestOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Long getExecTime() {
        return _execTime;
    }
    
    public java.lang.Long getListBuildTime() {
        return _listBuildTime;
    }
    
    public java.lang.Long getNtfOk() {
        return _ntfOk;
    }
    
    public Status getStatus() {
        return _status;
    }
    
    public java.lang.Long getTxError() {
        return _txError;
    }
    
    public java.lang.Long getTxOk() {
        return _txOk;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public StartTestOutputBuilder setExecTime(final java.lang.Long value) {
        this._execTime = value;
        return this;
    }
    
     
    public StartTestOutputBuilder setListBuildTime(final java.lang.Long value) {
        this._listBuildTime = value;
        return this;
    }
    
     
     private static void checkNtfOkRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setNtfOk(final java.lang.Long value) {
    if (value != null) {
        checkNtfOkRange(value);
    }
        this._ntfOk = value;
        return this;
    }
    
     
    public StartTestOutputBuilder setStatus(final Status value) {
        this._status = value;
        return this;
    }
    
     
     private static void checkTxErrorRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setTxError(final java.lang.Long value) {
    if (value != null) {
        checkTxErrorRange(value);
    }
        this._txError = value;
        return this;
    }
    
     
     private static void checkTxOkRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setTxOk(final java.lang.Long value) {
    if (value != null) {
        checkTxOkRange(value);
    }
        this._txOk = value;
        return this;
    }
    
    public StartTestOutputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public StartTestOutputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestOutput build() {
        return new StartTestOutputImpl(this);
    }

    private static final class StartTestOutputImpl implements StartTestOutput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput.class;
        }

        private final java.lang.Long _execTime;
        private final java.lang.Long _listBuildTime;
        private final java.lang.Long _ntfOk;
        private final Status _status;
        private final java.lang.Long _txError;
        private final java.lang.Long _txOk;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> augmentation = Collections.emptyMap();

        private StartTestOutputImpl(StartTestOutputBuilder base) {
            this._execTime = base.getExecTime();
            this._listBuildTime = base.getListBuildTime();
            this._ntfOk = base.getNtfOk();
            this._status = base.getStatus();
            this._txError = base.getTxError();
            this._txOk = base.getTxOk();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Long getExecTime() {
            return _execTime;
        }
        
        @Override
        public java.lang.Long getListBuildTime() {
            return _listBuildTime;
        }
        
        @Override
        public java.lang.Long getNtfOk() {
            return _ntfOk;
        }
        
        @Override
        public Status getStatus() {
            return _status;
        }
        
        @Override
        public java.lang.Long getTxError() {
            return _txError;
        }
        
        @Override
        public java.lang.Long getTxOk() {
            return _txOk;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_execTime);
            result = prime * result + Objects.hashCode(_listBuildTime);
            result = prime * result + Objects.hashCode(_ntfOk);
            result = prime * result + Objects.hashCode(_status);
            result = prime * result + Objects.hashCode(_txError);
            result = prime * result + Objects.hashCode(_txOk);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput)obj;
            if (!Objects.equals(_execTime, other.getExecTime())) {
                return false;
            }
            if (!Objects.equals(_listBuildTime, other.getListBuildTime())) {
                return false;
            }
            if (!Objects.equals(_ntfOk, other.getNtfOk())) {
                return false;
            }
            if (!Objects.equals(_status, other.getStatus())) {
                return false;
            }
            if (!Objects.equals(_txError, other.getTxError())) {
                return false;
            }
            if (!Objects.equals(_txOk, other.getTxOk())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                StartTestOutputImpl otherImpl = (StartTestOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "StartTestOutput [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_execTime != null) {
                builder.append("_execTime=");
                builder.append(_execTime);
                builder.append(", ");
            }
            if (_listBuildTime != null) {
                builder.append("_listBuildTime=");
                builder.append(_listBuildTime);
                builder.append(", ");
            }
            if (_ntfOk != null) {
                builder.append("_ntfOk=");
                builder.append(_ntfOk);
                builder.append(", ");
            }
            if (_status != null) {
                builder.append("_status=");
                builder.append(_status);
                builder.append(", ");
            }
            if (_txError != null) {
                builder.append("_txError=");
                builder.append(_txError);
                builder.append(", ");
            }
            if (_txOk != null) {
                builder.append("_txOk=");
                builder.append(_txOk);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
