package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * container test-exec {
 *     list outer-list {
 *         key "id"
 *         leaf id {
 *             type int32;
 *         }
 *         choice outer-choice {
 *             case one {
 *                 leaf one {
 *                     type string;
 *                 }
 *             }
 *             case two-three {
 *                 leaf two {
 *                     type string;
 *                 }
 *                 leaf three {
 *                     type string;
 *                 }
 *             }
 *         }
 *         list inner-list {
 *             key "name"
 *             leaf name {
 *                 type int32;
 *             }
 *             leaf value {
 *                 type string;
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>dsbenchmark/test-exec</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExecBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExecBuilder
 *
 */
public interface TestExec
    extends
    ChildOf<DsbenchmarkData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:dsbenchmark",
        "2015-01-05", "test-exec").intern();

    /**
     * @return <code>java.util.List</code> <code>outerList</code>, or <code>null</code> if not present
     */
    List<OuterList> getOuterList();

}

