package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus.ExecStatus;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * container test-status {
 *     leaf execStatus {
 *         type enumeration;
 *     }
 *     leaf testsCompleted {
 *         type testsCompleted;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>dsbenchmark/test-status</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatusBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatusBuilder
 *
 */
public interface TestStatus
    extends
    ChildOf<DsbenchmarkData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus>
{


    public enum ExecStatus {
        Idle(1, "idle"),
        
        Executing(2, "executing")
        ;
    
    
        java.lang.String name;
        int value;
        private static final java.util.Map<java.lang.Integer, ExecStatus> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ExecStatus> b = com.google.common.collect.ImmutableMap.builder();
            for (ExecStatus enumItem : ExecStatus.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private ExecStatus(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding ExecStatus item
         */
        public static ExecStatus forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:dsbenchmark",
        "2015-01-05", "test-status").intern();

    /**
     * Indicates whether a test run is in progress; only one test can run at a time
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus.ExecStatus</code> <code>execStatus</code>, or <code>null</code> if not present
     */
    ExecStatus getExecStatus();
    
    /**
     * Number of completed test runs
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>testsCompleted</code>, or <code>null</code> if not present
     */
    java.lang.Long getTestsCompleted();

}

