package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbench.payload.rev150709;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ntfbench-payload</b>
 * <pre>
 * grouping payload {
 *     list payload {
 *         key "id"
 *         leaf id {
 *             type int32;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ntfbench-payload/payload</i>
 *
 */
public interface Payload
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:ntfbench-payload",
        "2015-07-09", "payload").intern();

    /**
     * The payload for the notification
     *
     *
     *
     * @return <code>java.util.List</code> <code>payload</code>, or <code>null</code> if not present
     */
    List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbench.payload.rev150709.payload.Payload> getPayload();

}

