package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbenchmark</b>
 * <pre>
 * container output {
 *     leaf global-rtc-client-ok {
 *         type global-rtc-client-ok;
 *     }
 *     leaf global-rtc-client-error {
 *         type global-rtc-client-error;
 *     }
 *     leaf exec-time {
 *         type exec-time;
 *     }
 *     leaf rate {
 *         type rate;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbenchmark/start-test/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutputBuilder
 *
 */
public interface StartTestOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:rpcbenchmark",
        "2015-07-02", "output").intern();

    /**
     * Number of successful calls to the Global RPC Server for all test threads
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>globalRtcClientOk</code>, or <code>null</code> if not present
     */
    java.lang.Long getGlobalRtcClientOk();
    
    /**
     * Number of failed calls to the Global RPC server from all test threads
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>globalRtcClientError</code>, or <code>null</code> if not present
     */
    java.lang.Long getGlobalRtcClientError();
    
    /**
     * Test execution time, in milliseconds
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>execTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getExecTime();
    
    /**
     * RPC rate (Number of RPCs/sec)
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>rate</code>, or <code>null</code> if not present
     */
    java.lang.Long getRate();

}

