/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StartTestOutputBuilder
implements Builder<StartTestOutput> {
    private Long _dataChangeEventsOk;
    private Long _execTime;
    private Long _listBuildTime;
    private Long _ntfOk;
    private StartTestOutput.Status _status;
    private Long _txError;
    private Long _txOk;
    Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> augmentation = Collections.emptyMap();

    public StartTestOutputBuilder() {
    }

    public StartTestOutputBuilder(StartTestOutput base) {
        Map aug;
        this._dataChangeEventsOk = base.getDataChangeEventsOk();
        this._execTime = base.getExecTime();
        this._listBuildTime = base.getListBuildTime();
        this._ntfOk = base.getNtfOk();
        this._status = base.getStatus();
        this._txError = base.getTxError();
        this._txOk = base.getTxOk();
        if (base instanceof StartTestOutputImpl) {
            StartTestOutputImpl impl = (StartTestOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>(aug);
        }
    }

    public Long getDataChangeEventsOk() {
        return this._dataChangeEventsOk;
    }

    public Long getExecTime() {
        return this._execTime;
    }

    public Long getListBuildTime() {
        return this._listBuildTime;
    }

    public Long getNtfOk() {
        return this._ntfOk;
    }

    public StartTestOutput.Status getStatus() {
        return this._status;
    }

    public Long getTxError() {
        return this._txError;
    }

    public Long getTxOk() {
        return this._txOk;
    }

    public <E extends Augmentation<StartTestOutput>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkDataChangeEventsOkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setDataChangeEventsOk(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkDataChangeEventsOkRange(value);
        }
        this._dataChangeEventsOk = value;
        return this;
    }

    public StartTestOutputBuilder setExecTime(Long value) {
        this._execTime = value;
        return this;
    }

    public StartTestOutputBuilder setListBuildTime(Long value) {
        this._listBuildTime = value;
        return this;
    }

    private static void checkNtfOkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setNtfOk(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkNtfOkRange(value);
        }
        this._ntfOk = value;
        return this;
    }

    public StartTestOutputBuilder setStatus(StartTestOutput.Status value) {
        this._status = value;
        return this;
    }

    private static void checkTxErrorRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setTxError(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkTxErrorRange(value);
        }
        this._txError = value;
        return this;
    }

    private static void checkTxOkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setTxOk(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkTxOkRange(value);
        }
        this._txOk = value;
        return this;
    }

    public StartTestOutputBuilder addAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType, Augmentation<StartTestOutput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StartTestOutputBuilder removeAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestOutput build() {
        return new StartTestOutputImpl(this);
    }

    private static final class StartTestOutputImpl
    implements StartTestOutput {
        private final Long _dataChangeEventsOk;
        private final Long _execTime;
        private final Long _listBuildTime;
        private final Long _ntfOk;
        private final StartTestOutput.Status _status;
        private final Long _txError;
        private final Long _txOk;
        private Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StartTestOutputImpl(StartTestOutputBuilder base) {
            this._dataChangeEventsOk = base.getDataChangeEventsOk();
            this._execTime = base.getExecTime();
            this._listBuildTime = base.getListBuildTime();
            this._ntfOk = base.getNtfOk();
            this._status = base.getStatus();
            this._txError = base.getTxError();
            this._txOk = base.getTxOk();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<StartTestOutput> getImplementedInterface() {
            return StartTestOutput.class;
        }

        @Override
        public Long getDataChangeEventsOk() {
            return this._dataChangeEventsOk;
        }

        @Override
        public Long getExecTime() {
            return this._execTime;
        }

        @Override
        public Long getListBuildTime() {
            return this._listBuildTime;
        }

        @Override
        public Long getNtfOk() {
            return this._ntfOk;
        }

        @Override
        public StartTestOutput.Status getStatus() {
            return this._status;
        }

        @Override
        public Long getTxError() {
            return this._txError;
        }

        @Override
        public Long getTxOk() {
            return this._txOk;
        }

        public <E extends Augmentation<StartTestOutput>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dataChangeEventsOk);
            result = 31 * result + Objects.hashCode(this._execTime);
            result = 31 * result + Objects.hashCode(this._listBuildTime);
            result = 31 * result + Objects.hashCode(this._ntfOk);
            result = 31 * result + Objects.hashCode((Object)this._status);
            result = 31 * result + Objects.hashCode(this._txError);
            result = 31 * result + Objects.hashCode(this._txOk);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StartTestOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StartTestOutput other = (StartTestOutput)obj;
            if (!Objects.equals(this._dataChangeEventsOk, other.getDataChangeEventsOk())) {
                return false;
            }
            if (!Objects.equals(this._execTime, other.getExecTime())) {
                return false;
            }
            if (!Objects.equals(this._listBuildTime, other.getListBuildTime())) {
                return false;
            }
            if (!Objects.equals(this._ntfOk, other.getNtfOk())) {
                return false;
            }
            if (!Objects.equals((Object)this._status, (Object)other.getStatus())) {
                return false;
            }
            if (!Objects.equals(this._txError, other.getTxError())) {
                return false;
            }
            if (!Objects.equals(this._txOk, other.getTxOk())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StartTestOutputImpl otherImpl = (StartTestOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StartTestOutput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataChangeEventsOk", (Object)this._dataChangeEventsOk);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_execTime", (Object)this._execTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_listBuildTime", (Object)this._listBuildTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ntfOk", (Object)this._ntfOk);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_status", (Object)((Object)this._status));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_txError", (Object)this._txError);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_txOk", (Object)this._txOk);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

