/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.InnerList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.OuterChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OuterListBuilder
implements Builder<OuterList> {
    private Integer _id;
    private List<InnerList> _innerList;
    private OuterChoice _outerChoice;
    private OuterListKey key;
    Map<Class<? extends Augmentation<OuterList>>, Augmentation<OuterList>> augmentation = Collections.emptyMap();

    public OuterListBuilder() {
    }

    public OuterListBuilder(OuterList base) {
        Map aug;
        this.key = base.key();
        this._id = base.getId();
        this._innerList = base.getInnerList();
        this._outerChoice = base.getOuterChoice();
        if (base instanceof OuterListImpl) {
            OuterListImpl impl = (OuterListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OuterList>>, Augmentation<OuterList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OuterList>>, Augmentation<OuterList>>(aug);
        }
    }

    public OuterListKey key() {
        return this.key;
    }

    public Integer getId() {
        return this._id;
    }

    public List<InnerList> getInnerList() {
        return this._innerList;
    }

    public OuterChoice getOuterChoice() {
        return this._outerChoice;
    }

    public <E extends Augmentation<OuterList>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public OuterListBuilder withKey(OuterListKey key) {
        this.key = key;
        return this;
    }

    public OuterListBuilder setId(Integer value) {
        this._id = value;
        return this;
    }

    public OuterListBuilder setInnerList(List<InnerList> values) {
        this._innerList = values;
        return this;
    }

    public OuterListBuilder setOuterChoice(OuterChoice value) {
        this._outerChoice = value;
        return this;
    }

    public OuterListBuilder addAugmentation(Class<? extends Augmentation<OuterList>> augmentationType, Augmentation<OuterList> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OuterList>>, Augmentation<OuterList>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OuterListBuilder removeAugmentation(Class<? extends Augmentation<OuterList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OuterList build() {
        return new OuterListImpl(this);
    }

    private static final class OuterListImpl
    implements OuterList {
        private final Integer _id;
        private final List<InnerList> _innerList;
        private final OuterChoice _outerChoice;
        private final OuterListKey key;
        private Map<Class<? extends Augmentation<OuterList>>, Augmentation<OuterList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        OuterListImpl(OuterListBuilder base) {
            this.key = base.key() != null ? base.key() : new OuterListKey(base.getId());
            this._id = this.key.getId();
            this._innerList = base.getInnerList();
            this._outerChoice = base.getOuterChoice();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<OuterList> getImplementedInterface() {
            return OuterList.class;
        }

        @Override
        public OuterListKey key() {
            return this.key;
        }

        @Override
        public Integer getId() {
            return this._id;
        }

        @Override
        public List<InnerList> getInnerList() {
            return this._innerList;
        }

        @Override
        public OuterChoice getOuterChoice() {
            return this._outerChoice;
        }

        public <E extends Augmentation<OuterList>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._innerList);
            result = 31 * result + Objects.hashCode(this._outerChoice);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OuterList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OuterList other = (OuterList)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._innerList, other.getInnerList())) {
                return false;
            }
            if (!Objects.equals(this._outerChoice, other.getOuterChoice())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OuterListImpl otherImpl = (OuterListImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OuterList>>, Augmentation<OuterList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"OuterList");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_innerList", this._innerList);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_outerChoice", (Object)this._outerChoice);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

