/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.InnerList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.InnerListKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InnerListBuilder
implements Builder<InnerList> {
    private Integer _name;
    private String _value;
    private InnerListKey key;
    Map<Class<? extends Augmentation<InnerList>>, Augmentation<InnerList>> augmentation = Collections.emptyMap();

    public InnerListBuilder() {
    }

    public InnerListBuilder(InnerList base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._value = base.getValue();
        if (base instanceof InnerListImpl) {
            InnerListImpl impl = (InnerListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InnerList>>, Augmentation<InnerList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InnerList>>, Augmentation<InnerList>>(aug);
        }
    }

    public InnerListKey key() {
        return this.key;
    }

    public Integer getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public <E extends Augmentation<InnerList>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public InnerListBuilder withKey(InnerListKey key) {
        this.key = key;
        return this;
    }

    public InnerListBuilder setName(Integer value) {
        this._name = value;
        return this;
    }

    public InnerListBuilder setValue(String value) {
        this._value = value;
        return this;
    }

    public InnerListBuilder addAugmentation(Class<? extends Augmentation<InnerList>> augmentationType, Augmentation<InnerList> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InnerList>>, Augmentation<InnerList>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InnerListBuilder removeAugmentation(Class<? extends Augmentation<InnerList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InnerList build() {
        return new InnerListImpl(this);
    }

    private static final class InnerListImpl
    implements InnerList {
        private final Integer _name;
        private final String _value;
        private final InnerListKey key;
        private Map<Class<? extends Augmentation<InnerList>>, Augmentation<InnerList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        InnerListImpl(InnerListBuilder base) {
            this.key = base.key() != null ? base.key() : new InnerListKey(base.getName());
            this._name = this.key.getName();
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<InnerList> getImplementedInterface() {
            return InnerList.class;
        }

        @Override
        public InnerListKey key() {
            return this.key;
        }

        @Override
        public Integer getName() {
            return this._name;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        public <E extends Augmentation<InnerList>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InnerList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InnerList other = (InnerList)obj;
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InnerListImpl otherImpl = (InnerListImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InnerList>>, Augmentation<InnerList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"InnerList");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

