/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StartTestOutputBuilder
implements Builder<StartTestOutput> {
    private Long _listenerElapsedTime;
    private Long _listenerOk;
    private Long _listenerRate;
    private Long _producerElapsedTime;
    private Long _producerError;
    private Long _producerOk;
    private Long _producerRate;
    Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> augmentation = Collections.emptyMap();

    public StartTestOutputBuilder() {
    }

    public StartTestOutputBuilder(StartTestOutput base) {
        Map aug;
        this._listenerElapsedTime = base.getListenerElapsedTime();
        this._listenerOk = base.getListenerOk();
        this._listenerRate = base.getListenerRate();
        this._producerElapsedTime = base.getProducerElapsedTime();
        this._producerError = base.getProducerError();
        this._producerOk = base.getProducerOk();
        this._producerRate = base.getProducerRate();
        if (base instanceof StartTestOutputImpl) {
            StartTestOutputImpl impl = (StartTestOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>(aug);
        }
    }

    public Long getListenerElapsedTime() {
        return this._listenerElapsedTime;
    }

    public Long getListenerOk() {
        return this._listenerOk;
    }

    public Long getListenerRate() {
        return this._listenerRate;
    }

    public Long getProducerElapsedTime() {
        return this._producerElapsedTime;
    }

    public Long getProducerError() {
        return this._producerError;
    }

    public Long getProducerOk() {
        return this._producerOk;
    }

    public Long getProducerRate() {
        return this._producerRate;
    }

    public <E extends Augmentation<StartTestOutput>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkListenerElapsedTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setListenerElapsedTime(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkListenerElapsedTimeRange(value);
        }
        this._listenerElapsedTime = value;
        return this;
    }

    private static void checkListenerOkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setListenerOk(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkListenerOkRange(value);
        }
        this._listenerOk = value;
        return this;
    }

    private static void checkListenerRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setListenerRate(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkListenerRateRange(value);
        }
        this._listenerRate = value;
        return this;
    }

    private static void checkProducerElapsedTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setProducerElapsedTime(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkProducerElapsedTimeRange(value);
        }
        this._producerElapsedTime = value;
        return this;
    }

    private static void checkProducerErrorRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setProducerError(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkProducerErrorRange(value);
        }
        this._producerError = value;
        return this;
    }

    private static void checkProducerOkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setProducerOk(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkProducerOkRange(value);
        }
        this._producerOk = value;
        return this;
    }

    private static void checkProducerRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setProducerRate(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkProducerRateRange(value);
        }
        this._producerRate = value;
        return this;
    }

    public StartTestOutputBuilder addAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType, Augmentation<StartTestOutput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StartTestOutputBuilder removeAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestOutput build() {
        return new StartTestOutputImpl(this);
    }

    private static final class StartTestOutputImpl
    implements StartTestOutput {
        private final Long _listenerElapsedTime;
        private final Long _listenerOk;
        private final Long _listenerRate;
        private final Long _producerElapsedTime;
        private final Long _producerError;
        private final Long _producerOk;
        private final Long _producerRate;
        private Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StartTestOutputImpl(StartTestOutputBuilder base) {
            this._listenerElapsedTime = base.getListenerElapsedTime();
            this._listenerOk = base.getListenerOk();
            this._listenerRate = base.getListenerRate();
            this._producerElapsedTime = base.getProducerElapsedTime();
            this._producerError = base.getProducerError();
            this._producerOk = base.getProducerOk();
            this._producerRate = base.getProducerRate();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<StartTestOutput> getImplementedInterface() {
            return StartTestOutput.class;
        }

        @Override
        public Long getListenerElapsedTime() {
            return this._listenerElapsedTime;
        }

        @Override
        public Long getListenerOk() {
            return this._listenerOk;
        }

        @Override
        public Long getListenerRate() {
            return this._listenerRate;
        }

        @Override
        public Long getProducerElapsedTime() {
            return this._producerElapsedTime;
        }

        @Override
        public Long getProducerError() {
            return this._producerError;
        }

        @Override
        public Long getProducerOk() {
            return this._producerOk;
        }

        @Override
        public Long getProducerRate() {
            return this._producerRate;
        }

        public <E extends Augmentation<StartTestOutput>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._listenerElapsedTime);
            result = 31 * result + Objects.hashCode(this._listenerOk);
            result = 31 * result + Objects.hashCode(this._listenerRate);
            result = 31 * result + Objects.hashCode(this._producerElapsedTime);
            result = 31 * result + Objects.hashCode(this._producerError);
            result = 31 * result + Objects.hashCode(this._producerOk);
            result = 31 * result + Objects.hashCode(this._producerRate);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StartTestOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StartTestOutput other = (StartTestOutput)obj;
            if (!Objects.equals(this._listenerElapsedTime, other.getListenerElapsedTime())) {
                return false;
            }
            if (!Objects.equals(this._listenerOk, other.getListenerOk())) {
                return false;
            }
            if (!Objects.equals(this._listenerRate, other.getListenerRate())) {
                return false;
            }
            if (!Objects.equals(this._producerElapsedTime, other.getProducerElapsedTime())) {
                return false;
            }
            if (!Objects.equals(this._producerError, other.getProducerError())) {
                return false;
            }
            if (!Objects.equals(this._producerOk, other.getProducerOk())) {
                return false;
            }
            if (!Objects.equals(this._producerRate, other.getProducerRate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StartTestOutputImpl otherImpl = (StartTestOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StartTestOutput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_listenerElapsedTime", (Object)this._listenerElapsedTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_listenerOk", (Object)this._listenerOk);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_listenerRate", (Object)this._listenerRate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_producerElapsedTime", (Object)this._producerElapsedTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_producerError", (Object)this._producerError);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_producerOk", (Object)this._producerOk);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_producerRate", (Object)this._producerRate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

