/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StartTestOutputBuilder
implements Builder<StartTestOutput> {
    private Long _execTime;
    private Long _globalRtcClientError;
    private Long _globalRtcClientOk;
    private Long _rate;
    Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> augmentation = Collections.emptyMap();

    public StartTestOutputBuilder() {
    }

    public StartTestOutputBuilder(StartTestOutput base) {
        Map aug;
        this._execTime = base.getExecTime();
        this._globalRtcClientError = base.getGlobalRtcClientError();
        this._globalRtcClientOk = base.getGlobalRtcClientOk();
        this._rate = base.getRate();
        if (base instanceof StartTestOutputImpl) {
            StartTestOutputImpl impl = (StartTestOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>(aug);
        }
    }

    public Long getExecTime() {
        return this._execTime;
    }

    public Long getGlobalRtcClientError() {
        return this._globalRtcClientError;
    }

    public Long getGlobalRtcClientOk() {
        return this._globalRtcClientOk;
    }

    public Long getRate() {
        return this._rate;
    }

    public <E extends Augmentation<StartTestOutput>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkExecTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setExecTime(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkExecTimeRange(value);
        }
        this._execTime = value;
        return this;
    }

    private static void checkGlobalRtcClientErrorRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setGlobalRtcClientError(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkGlobalRtcClientErrorRange(value);
        }
        this._globalRtcClientError = value;
        return this;
    }

    private static void checkGlobalRtcClientOkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setGlobalRtcClientOk(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkGlobalRtcClientOkRange(value);
        }
        this._globalRtcClientOk = value;
        return this;
    }

    private static void checkRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (Object)value);
    }

    public StartTestOutputBuilder setRate(Long value) {
        if (value != null) {
            StartTestOutputBuilder.checkRateRange(value);
        }
        this._rate = value;
        return this;
    }

    public StartTestOutputBuilder addAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType, Augmentation<StartTestOutput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StartTestOutputBuilder removeAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestOutput build() {
        return new StartTestOutputImpl(this);
    }

    private static final class StartTestOutputImpl
    implements StartTestOutput {
        private final Long _execTime;
        private final Long _globalRtcClientError;
        private final Long _globalRtcClientOk;
        private final Long _rate;
        private Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StartTestOutputImpl(StartTestOutputBuilder base) {
            this._execTime = base.getExecTime();
            this._globalRtcClientError = base.getGlobalRtcClientError();
            this._globalRtcClientOk = base.getGlobalRtcClientOk();
            this._rate = base.getRate();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<StartTestOutput> getImplementedInterface() {
            return StartTestOutput.class;
        }

        @Override
        public Long getExecTime() {
            return this._execTime;
        }

        @Override
        public Long getGlobalRtcClientError() {
            return this._globalRtcClientError;
        }

        @Override
        public Long getGlobalRtcClientOk() {
            return this._globalRtcClientOk;
        }

        @Override
        public Long getRate() {
            return this._rate;
        }

        public <E extends Augmentation<StartTestOutput>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._execTime);
            result = 31 * result + Objects.hashCode(this._globalRtcClientError);
            result = 31 * result + Objects.hashCode(this._globalRtcClientOk);
            result = 31 * result + Objects.hashCode(this._rate);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StartTestOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StartTestOutput other = (StartTestOutput)obj;
            if (!Objects.equals(this._execTime, other.getExecTime())) {
                return false;
            }
            if (!Objects.equals(this._globalRtcClientError, other.getGlobalRtcClientError())) {
                return false;
            }
            if (!Objects.equals(this._globalRtcClientOk, other.getGlobalRtcClientOk())) {
                return false;
            }
            if (!Objects.equals(this._rate, other.getRate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StartTestOutputImpl otherImpl = (StartTestOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StartTestOutput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_execTime", (Object)this._execTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_globalRtcClientError", (Object)this._globalRtcClientError);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_globalRtcClientOk", (Object)this._globalRtcClientOk);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_rate", (Object)this._rate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

