package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * grouping payload {
 *   list payload {
 *     key id;
 *     leaf id {
 *       type int32;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>rpcbench-payload/payload</i>
 *
 */
public interface Payload
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("payload");

    @Override
    Class<? extends Payload> implementedInterface();
    
    /**
     * The input and output payload for the RPC Benchmark's Global RPC Server (a list
     * of integers)
     *
     *
     *
     * @return <code>java.util.List</code> <code>payload</code>, or <code>null</code> if not present
     */
    @Nullable List<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload> getPayload();
    
    /**
     * @return <code>java.util.List</code> <code>payload</code>, or an empty list if it is not present
     */
    default @NonNull List<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload> nonnullPayload() {
        return CodeHelpers.nonnull(getPayload());
    }

}

