package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * input input {
 *   leaf node {
 *     ext:context-reference node-context;
 *     type instance-identifier;
 *   }
 *   uses payload;
 * }
 * </pre>The schema path to identify an instance is
 * <i>rpcbench-payload/routed-rpc-bench/input</i>
 *
 * <p>To create instances of this class use {@link RoutedRpcBenchInputBuilder}.
 * @see RoutedRpcBenchInputBuilder
 *
 */
public interface RoutedRpcBenchInput
    extends
    Payload,
    RpcInput,
    Augmentable<RoutedRpcBenchInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput.class;
    }
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>node</code>, or <code>null</code> if not present
     */
    @RoutingContext
    (
    value=org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.NodeContext.class
    )
    @Nullable InstanceIdentifier<?> getNode();

}

