package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Copyright © 2015, 2018 Cisco Systems, Inc. and others. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public 
 * License v1.0 which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * module rpcbench-payload {
 *   yang-version 1;
 *   namespace rpcbench-payload;
 *   prefix rpcb;
 *   import yang-ext {
 *     prefix ext;
 *     revision-date 2013-07-09;
 *   }
 *   revision 2015-07-02 {
 *   }
 *   identity node-context {
 *   }
 *   grouping payload {
 *     list payload {
 *       key id;
 *       leaf id {
 *         type int32;
 *       }
 *     }
 *   }
 *   rpc global-rpc-bench {
 *     input input {
 *       uses payload;
 *     }
 *     output output {
 *       uses payload;
 *     }
 *   }
 *   rpc routed-rpc-bench {
 *     input input {
 *       leaf node {
 *         ext:context-reference node-context;
 *         type instance-identifier;
 *       }
 *       uses payload;
 *     }
 *     output output {
 *       uses payload;
 *     }
 *   }
 *   container rpcbench-rpc-routes {
 *     list rpc-route {
 *       key id;
 *       ext:context-instance node-context;
 *       leaf id {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface RpcbenchPayloadData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes</code> <code>rpcbenchRpcRoutes</code>, or <code>null</code> if not present
     */
    @Nullable RpcbenchRpcRoutes getRpcbenchRpcRoutes();

}

