package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Routed RPC server context instances (i.e. instances to which RPC calls are 
 * routed)
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * list rpc-route {
 *   key id;
 *   ext:context-instance node-context;
 *   leaf id {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>rpcbench-payload/rpcbench-rpc-routes/rpc-route</i>
 *
 * <p>To create instances of this class use {@link RpcRouteBuilder}.
 * @see RpcRouteBuilder
 * @see RpcRouteKey
 *
 */
public interface RpcRoute
    extends
    ChildOf<RpcbenchRpcRoutes>,
    Augmentable<RpcRoute>,
    Identifiable<RpcRouteKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("rpc-route");

    @Override
    default Class<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute> implementedInterface() {
        return org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>id</code>, or <code>null</code> if not present
     */
    @Nullable String getId();
    
    @Override
    RpcRouteKey key();

}

