package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>dsbenchmark</b>
 * <pre>
 * rpc start-test {
 *   input input {
 *     leaf operation {
 *       type enumeration {
 *         enum PUT {
 *           value 1;
 *         }
 *         enum MERGE {
 *           value 2;
 *         }
 *         enum DELETE {
 *           value 3;
 *         }
 *         enum READ {
 *           value 4;
 *         }
 *       }
 *     }
 *     leaf data-format {
 *       type enumeration {
 *         enum BINDING-AWARE {
 *           value 1;
 *         }
 *         enum BINDING-INDEPENDENT {
 *           value 2;
 *         }
 *       }
 *     }
 *     leaf transaction-type {
 *       type enumeration {
 *         enum SIMPLE-TX {
 *           value 1;
 *         }
 *         enum TX-CHAINING {
 *           value 2;
 *         }
 *       }
 *     }
 *     leaf data-store {
 *       type enumeration {
 *         enum CONFIG {
 *           value 1;
 *         }
 *         enum OPERATIONAL {
 *           value 2;
 *         }
 *         enum BOTH {
 *           value 3;
 *         }
 *       }
 *     }
 *     leaf outerElements {
 *       type uint32;
 *       default 100000;
 *     }
 *     leaf innerElements {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf putsPerTx {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf listeners {
 *       type uint32;
 *       default 0;
 *     }
 *   }
 *   output output {
 *     leaf status {
 *       type enumeration {
 *         enum OK {
 *           value 1;
 *         }
 *         enum FAILED {
 *           value 2;
 *         }
 *         enum TEST-IN-PROGRESS {
 *           value 3;
 *         }
 *       }
 *     }
 *     leaf listBuildTime {
 *       type int64;
 *       units microseconds;
 *     }
 *     leaf execTime {
 *       type int64;
 *       units microseconds;
 *     }
 *     leaf txOk {
 *       type uint32;
 *     }
 *     leaf txError {
 *       type uint32;
 *     }
 *     leaf ntfOk {
 *       type uint32;
 *     }
 *     leaf dataChangeEventsOk {
 *       type uint32;
 *     }
 *   }
 * }
 * rpc cleanup-store {
 * }
 * </pre>
 *
 */
public interface DsbenchmarkService
    extends
    RpcService
{




    /**
     * Start a new data store write test run
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input);
    
    /**
     * Delete data in the test-exec container that may have been left behind from a
     * previous test run
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<CleanupStoreOutput>> cleanupStore(CleanupStoreInput input);

}

