package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * input input {
 *   leaf operation {
 *     type enumeration {
 *       enum PUT {
 *         value 1;
 *       }
 *       enum MERGE {
 *         value 2;
 *       }
 *       enum DELETE {
 *         value 3;
 *       }
 *       enum READ {
 *         value 4;
 *       }
 *     }
 *   }
 *   leaf data-format {
 *     type enumeration {
 *       enum BINDING-AWARE {
 *         value 1;
 *       }
 *       enum BINDING-INDEPENDENT {
 *         value 2;
 *       }
 *     }
 *   }
 *   leaf transaction-type {
 *     type enumeration {
 *       enum SIMPLE-TX {
 *         value 1;
 *       }
 *       enum TX-CHAINING {
 *         value 2;
 *       }
 *     }
 *   }
 *   leaf data-store {
 *     type enumeration {
 *       enum CONFIG {
 *         value 1;
 *       }
 *       enum OPERATIONAL {
 *         value 2;
 *       }
 *       enum BOTH {
 *         value 3;
 *       }
 *     }
 *   }
 *   leaf outerElements {
 *     type uint32;
 *     default 100000;
 *   }
 *   leaf innerElements {
 *     type uint32;
 *     default 1;
 *   }
 *   leaf putsPerTx {
 *     type uint32;
 *     default 1;
 *   }
 *   leaf listeners {
 *     type uint32;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>dsbenchmark/start-test/input</i>
 *
 * <p>To create instances of this class use {@link StartTestInputBuilder}.
 * @see StartTestInputBuilder
 *
 */
public interface StartTestInput
    extends
    RpcInput,
    Augmentable<StartTestInput>
{


    public enum Operation implements Enumeration {
        /**
         * The put operation
         *
         */
        PUT(1, "PUT"),
        
        /**
         * The merge operation
         *
         */
        MERGE(2, "MERGE"),
        
        /**
         * Delete items from a list sorted in the data store
         *
         */
        DELETE(3, "DELETE"),
        
        /**
         * The read operation
         *
         */
        READ(4, "READ")
        ;
    
        private static final Map<String, Operation> NAME_MAP;
        private static final Map<Integer, Operation> VALUE_MAP;
    
        static {
            final Builder<String, Operation> nb = ImmutableMap.builder();
            final Builder<Integer, Operation> vb = ImmutableMap.builder();
            for (Operation enumItem : Operation.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Operation(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Operation item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Operation> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Operation item, or null if no such item exists
         */
        public static Operation forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }
    
    public enum DataFormat implements Enumeration {
        BINDINGAWARE(1, "BINDING-AWARE"),
        
        BINDINGINDEPENDENT(2, "BINDING-INDEPENDENT")
        ;
    
        private static final Map<String, DataFormat> NAME_MAP;
        private static final Map<Integer, DataFormat> VALUE_MAP;
    
        static {
            final Builder<String, DataFormat> nb = ImmutableMap.builder();
            final Builder<Integer, DataFormat> vb = ImmutableMap.builder();
            for (DataFormat enumItem : DataFormat.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private DataFormat(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding DataFormat item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<DataFormat> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding DataFormat item, or null if no such item exists
         */
        public static DataFormat forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }
    
    public enum TransactionType implements Enumeration {
        SIMPLETX(1, "SIMPLE-TX"),
        
        TXCHAINING(2, "TX-CHAINING")
        ;
    
        private static final Map<String, TransactionType> NAME_MAP;
        private static final Map<Integer, TransactionType> VALUE_MAP;
    
        static {
            final Builder<String, TransactionType> nb = ImmutableMap.builder();
            final Builder<Integer, TransactionType> vb = ImmutableMap.builder();
            for (TransactionType enumItem : TransactionType.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private TransactionType(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding TransactionType item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<TransactionType> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding TransactionType item, or null if no such item exists
         */
        public static TransactionType forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }
    
    public enum DataStore implements Enumeration {
        CONFIG(1, "CONFIG"),
        
        OPERATIONAL(2, "OPERATIONAL"),
        
        BOTH(3, "BOTH")
        ;
    
        private static final Map<String, DataStore> NAME_MAP;
        private static final Map<Integer, DataStore> VALUE_MAP;
    
        static {
            final Builder<String, DataStore> nb = ImmutableMap.builder();
            final Builder<Integer, DataStore> vb = ImmutableMap.builder();
            for (DataStore enumItem : DataStore.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private DataStore(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding DataStore item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<DataStore> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding DataStore item, or null if no such item exists
         */
        public static DataStore forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.class;
    }
    
    /**
     * Type of the transaction operation to benchmark
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.Operation</code> <code>operation</code>, or <code>null</code> if not present
     */
    @Nullable Operation getOperation();
    
    /**
     * Data format:-binding-aware or binding-independent
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataFormat</code> <code>dataFormat</code>, or <code>null</code> if not present
     */
    @Nullable DataFormat getDataFormat();
    
    /**
     * Data format:-binding-aware or binding-independent
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.TransactionType</code> <code>transactionType</code>, or <code>null</code> if not present
     */
    @Nullable TransactionType getTransactionType();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataStore</code> <code>dataStore</code>, or <code>null</code> if not present
     */
    @Nullable DataStore getDataStore();
    
    /**
     * Number of elements in the OuterList
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>outerElements</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getOuterElements();
    
    /**
     * Number of elements in the InnerList
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>innerElements</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getInnerElements();
    
    /**
     * Number of write operations (PUT, MERGE, or DELETE) per transaction submit
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>putsPerTx</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getPutsPerTx();
    
    /**
     * Number of data tree change listeners listening for changes on the test exec
     * tree.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>listeners</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getListeners();

}

