package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * container test-exec {
 *   list outer-list {
 *     key id;
 *     leaf id {
 *       type int32;
 *     }
 *     choice outer-choice {
 *       case one {
 *         leaf one {
 *           type string;
 *         }
 *       }
 *       case two-three {
 *         leaf two {
 *           type string;
 *         }
 *         leaf three {
 *           type string;
 *         }
 *       }
 *     }
 *     list inner-list {
 *       key name;
 *       leaf name {
 *         type int32;
 *       }
 *       leaf value {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>dsbenchmark/test-exec</i>
 *
 * <p>To create instances of this class use {@link TestExecBuilder}.
 * @see TestExecBuilder
 *
 */
public interface TestExec
    extends
    ChildOf<DsbenchmarkData>,
    Augmentable<TestExec>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("test-exec");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>outerList</code>, or <code>null</code> if not present
     */
    @Nullable List<OuterList> getOuterList();
    
    /**
     * @return <code>java.util.List</code> <code>outerList</code>, or an empty list if it is not present
     */
    default @NonNull List<OuterList> nonnullOuterList() {
        return CodeHelpers.nonnull(getOuterList());
    }

}

