package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbench.payload.rev150709;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ntfbench-payload</b>
 * <pre>
 * grouping payload {
 *   list payload {
 *     key id;
 *     leaf id {
 *       type int32;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ntfbench-payload/payload</i>
 *
 */
public interface Payload
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("payload");

    @Override
    Class<? extends Payload> implementedInterface();
    
    /**
     * The payload for the notification
     *
     *
     *
     * @return <code>java.util.List</code> <code>payload</code>, or <code>null</code> if not present
     */
    @Nullable List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbench.payload.rev150709.payload.Payload> getPayload();
    
    /**
     * @return <code>java.util.List</code> <code>payload</code>, or an empty list if it is not present
     */
    default @NonNull List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbench.payload.rev150709.payload.Payload> nonnullPayload() {
        return CodeHelpers.nonnull(getPayload());
    }

}

