package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>ntfbenchmark</b>
 * <pre>
 * rpc test-status {
 *   output output {
 *     leaf execStatus {
 *       type enumeration {
 *         enum idle {
 *           value 1;
 *         }
 *         enum executing {
 *           value 2;
 *         }
 *       }
 *     }
 *     leaf ntf-cnt {
 *       type uint32;
 *       default 0;
 *     }
 *   }
 * }
 * rpc start-test {
 *   input input {
 *     leaf producer-type {
 *       type enumeration {
 *         enum BLOCKING {
 *           value 1;
 *         }
 *         enum DROPPING {
 *           value 2;
 *         }
 *       }
 *     }
 *     leaf producers {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf listeners {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf payload-size {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf iterations {
 *       type uint32;
 *       default 1;
 *     }
 *   }
 *   output output {
 *     leaf listener-ok {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf producer-ok {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf producer-error {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf producer-elapsed-time {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf listener-elapsed-time {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf producer-rate {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf listener-rate {
 *       type uint32;
 *       default 0;
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface NtfbenchmarkService
    extends
    RpcService
{




    /**
     * Get test status
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<TestStatusOutput>> testStatus(TestStatusInput input);
    
    /**
     * Start a new RPC Benchmark test
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input);

}

