package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>rpcbenchmark</b>
 * <pre>
 * rpc test-status {
 *   output output {
 *     leaf execStatus {
 *       type enumeration {
 *         enum idle {
 *           value 1;
 *         }
 *         enum executing {
 *           value 2;
 *         }
 *       }
 *     }
 *     leaf global-server-cnt {
 *       type uint32;
 *       default 0;
 *     }
 *   }
 * }
 * rpc start-test {
 *   input input {
 *     leaf operation {
 *       type enumeration {
 *         enum GLOBAL-RTC {
 *           value 1;
 *         }
 *         enum ROUTED-RTC {
 *           value 2;
 *         }
 *       }
 *     }
 *     leaf num-clients {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf num-servers {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf payload-size {
 *       type uint32;
 *       default 1;
 *     }
 *     leaf iterations {
 *       type uint32;
 *       default 1;
 *     }
 *   }
 *   output output {
 *     leaf global-rtc-client-ok {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf global-rtc-client-error {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf exec-time {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf rate {
 *       type uint32;
 *       default 0;
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface RpcbenchmarkService
    extends
    RpcService
{




    /**
     * Get test status
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<TestStatusOutput>> testStatus(TestStatusInput input);
    
    /**
     * Start a new RPC Benchmark test run
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input);

}

