package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>rpcbench-payload</b>
 * <pre>
 * rpc global-rpc-bench {
 *   input input {
 *     uses payload;
 *   }
 *   output output {
 *     uses payload;
 *   }
 * }
 * rpc routed-rpc-bench {
 *   input input {
 *     leaf node {
 *       ext:context-reference node-context;
 *       type instance-identifier;
 *     }
 *     uses payload;
 *   }
 *   output output {
 *     uses payload;
 *   }
 * }
 * </pre>
 *
 */
public interface RpcbenchPayloadService
    extends
    RpcService
{




    /**
     * Interface to the RPC Benchmark's Global RPC Server. In each RPC call, the input
     * is copied on the output
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<GlobalRpcBenchOutput>> globalRpcBench(GlobalRpcBenchInput input);
    
    /**
     * Interface to RPC Benchmark's Routed RPC Servers. In each RPC call, the input is
     * copied on the output
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RoutedRpcBenchOutput>> routedRpcBench(RoutedRpcBenchInput input);

}

