package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import java.lang.Class;
import java.lang.Override;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * container rpcbench-rpc-routes {
 *   list rpc-route {
 *     key id;
 *     ext:context-instance node-context;
 *     leaf id {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>rpcbench-payload/rpcbench-rpc-routes</i>
 *
 * <p>To create instances of this class use {@link RpcbenchRpcRoutesBuilder}.
 * @see RpcbenchRpcRoutesBuilder
 *
 */
public interface RpcbenchRpcRoutes
    extends
    ChildOf<RpcbenchPayloadData>,
    Augmentable<RpcbenchRpcRoutes>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("rpcbench-rpc-routes");

    @Override
    default Class<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes> implementedInterface() {
        return org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes.class;
    }
    
    /**
     * Routed RPC server context instances (i.e. instances to which RPC calls are
     * routed)
     *
     *
     *
     * @return <code>java.util.Map</code> <code>rpcRoute</code>, or <code>null</code> if not present
     */
    @Nullable Map<RpcRouteKey, RpcRoute> getRpcRoute();
    
    /**
     * @return <code>java.util.Map</code> <code>rpcRoute</code>, or an empty list if it is not present
     */
    default @NonNull Map<RpcRouteKey, RpcRoute> nonnullRpcRoute() {
        return CodeHelpers.nonnull(getRpcRoute());
    }

}

