package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.InnerList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.InnerListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.OuterChoice;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * list outer-list {
 *   key id;
 *   leaf id {
 *     type int32;
 *   }
 *   choice outer-choice {
 *     case one {
 *       leaf one {
 *         type string;
 *       }
 *     }
 *     case two-three {
 *       leaf two {
 *         type string;
 *       }
 *       leaf three {
 *         type string;
 *       }
 *     }
 *   }
 *   list inner-list {
 *     key name;
 *     leaf name {
 *       type int32;
 *     }
 *     leaf value {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>dsbenchmark/test-exec/outer-list</i>
 *
 * <p>To create instances of this class use {@link OuterListBuilder}.
 * @see OuterListBuilder
 * @see OuterListKey
 *
 */
public interface OuterList
    extends
    ChildOf<TestExec>,
    Augmentable<OuterList>,
    Identifiable<OuterListKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("outer-list");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList.class;
    }
    
    /**
     * @return <code>java.lang.Integer</code> <code>id</code>, or <code>null</code> if not present
     */
    @Nullable Integer getId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.OuterChoice</code> <code>outerChoice</code>, or <code>null</code> if not present
     */
    @Nullable OuterChoice getOuterChoice();
    
    /**
     * @return <code>java.util.Map</code> <code>innerList</code>, or <code>null</code> if not present
     */
    @Nullable Map<InnerListKey, InnerList> getInnerList();
    
    /**
     * @return <code>java.util.Map</code> <code>innerList</code>, or an empty list if it is not present
     */
    default @NonNull Map<InnerListKey, InnerList> nonnullInnerList() {
        return CodeHelpers.nonnull(getInnerList());
    }
    
    @Override
    OuterListKey key();

}

