package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ntfbenchmark</b>
 * <pre>
 * output output {
 *   leaf listener-ok {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf producer-ok {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf producer-error {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf producer-elapsed-time {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf listener-elapsed-time {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf producer-rate {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf listener-rate {
 *     type uint32;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ntfbenchmark/start-test/output</i>
 *
 * <p>To create instances of this class use {@link StartTestOutputBuilder}.
 * @see StartTestOutputBuilder
 *
 */
public interface StartTestOutput
    extends
    RpcOutput,
    Augmentable<StartTestOutput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput.class;
    }
    
    /**
     * Number of successfully creceived notifications by all listeners
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>listenerOk</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getListenerOk();
    
    /**
     * Number of successfully generated notifications in all producer clients
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>producerOk</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getProducerOk();
    
    /**
     * Number of errors encoutered during notification generation at all producers
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>producerError</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getProducerError();
    
    /**
     * The time it took for all producers to finish (i.e. to send their notifications),
     * in milliseconds
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>producerElapsedTime</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getProducerElapsedTime();
    
    /**
     * The time it took for all listeners to finish (i.e. to receive their
     * notifications), in milliseconds
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>listenerElapsedTime</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getListenerElapsedTime();
    
    /**
     * RPC rate (Number of RPCs/sec)
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>producerRate</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getProducerRate();
    
    /**
     * RPC rate (Number of RPCs/sec)
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>listenerRate</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getListenerRate();

}

