package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link StartTestOutputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     StartTestOutputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new StartTestOutputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of StartTestOutputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see StartTestOutputBuilder
 * @see Builder
 *
 */
public class StartTestOutputBuilder implements Builder<StartTestOutput> {

    private Uint32 _listenerElapsedTime;
    private Uint32 _listenerOk;
    private Uint32 _listenerRate;
    private Uint32 _producerElapsedTime;
    private Uint32 _producerError;
    private Uint32 _producerOk;
    private Uint32 _producerRate;


    Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> augmentation = Collections.emptyMap();

    public StartTestOutputBuilder() {
    }

    public StartTestOutputBuilder(StartTestOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> aug =((AugmentationHolder<StartTestOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._listenerElapsedTime = base.getListenerElapsedTime();
        this._listenerOk = base.getListenerOk();
        this._listenerRate = base.getListenerRate();
        this._producerElapsedTime = base.getProducerElapsedTime();
        this._producerError = base.getProducerError();
        this._producerOk = base.getProducerOk();
        this._producerRate = base.getProducerRate();
    }


    public Uint32 getListenerElapsedTime() {
        return _listenerElapsedTime;
    }
    
    public Uint32 getListenerOk() {
        return _listenerOk;
    }
    
    public Uint32 getListenerRate() {
        return _listenerRate;
    }
    
    public Uint32 getProducerElapsedTime() {
        return _producerElapsedTime;
    }
    
    public Uint32 getProducerError() {
        return _producerError;
    }
    
    public Uint32 getProducerOk() {
        return _producerOk;
    }
    
    public Uint32 getProducerRate() {
        return _producerRate;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<StartTestOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StartTestOutputBuilder setListenerElapsedTime(final Uint32 value) {
        this._listenerElapsedTime = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setListenerElapsedTime(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder setListenerElapsedTime(final Long value) {
        return setListenerElapsedTime(CodeHelpers.compatUint(value));
    }
    
    public StartTestOutputBuilder setListenerOk(final Uint32 value) {
        this._listenerOk = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setListenerOk(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder setListenerOk(final Long value) {
        return setListenerOk(CodeHelpers.compatUint(value));
    }
    
    public StartTestOutputBuilder setListenerRate(final Uint32 value) {
        this._listenerRate = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setListenerRate(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder setListenerRate(final Long value) {
        return setListenerRate(CodeHelpers.compatUint(value));
    }
    
    public StartTestOutputBuilder setProducerElapsedTime(final Uint32 value) {
        this._producerElapsedTime = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setProducerElapsedTime(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder setProducerElapsedTime(final Long value) {
        return setProducerElapsedTime(CodeHelpers.compatUint(value));
    }
    
    public StartTestOutputBuilder setProducerError(final Uint32 value) {
        this._producerError = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setProducerError(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder setProducerError(final Long value) {
        return setProducerError(CodeHelpers.compatUint(value));
    }
    
    public StartTestOutputBuilder setProducerOk(final Uint32 value) {
        this._producerOk = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setProducerOk(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder setProducerOk(final Long value) {
        return setProducerOk(CodeHelpers.compatUint(value));
    }
    
    public StartTestOutputBuilder setProducerRate(final Uint32 value) {
        this._producerRate = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setProducerRate(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder setProducerRate(final Long value) {
        return setProducerRate(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StartTestOutputBuilder addAugmentation(Augmentation<StartTestOutput> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public StartTestOutputBuilder addAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType, Augmentation<StartTestOutput> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StartTestOutputBuilder removeAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private StartTestOutputBuilder doAddAugmentation(Class<? extends Augmentation<StartTestOutput>> augmentationType, Augmentation<StartTestOutput> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public StartTestOutput build() {
        return new StartTestOutputImpl(this);
    }

    private static final class StartTestOutputImpl
        extends AbstractAugmentable<StartTestOutput>
        implements StartTestOutput {
    
        private final Uint32 _listenerElapsedTime;
        private final Uint32 _listenerOk;
        private final Uint32 _listenerRate;
        private final Uint32 _producerElapsedTime;
        private final Uint32 _producerError;
        private final Uint32 _producerOk;
        private final Uint32 _producerRate;
    
        StartTestOutputImpl(StartTestOutputBuilder base) {
            super(base.augmentation);
            this._listenerElapsedTime = base.getListenerElapsedTime();
            this._listenerOk = base.getListenerOk();
            this._listenerRate = base.getListenerRate();
            this._producerElapsedTime = base.getProducerElapsedTime();
            this._producerError = base.getProducerError();
            this._producerOk = base.getProducerOk();
            this._producerRate = base.getProducerRate();
        }
    
        @Override
        public Uint32 getListenerElapsedTime() {
            return _listenerElapsedTime;
        }
        
        @Override
        public Uint32 getListenerOk() {
            return _listenerOk;
        }
        
        @Override
        public Uint32 getListenerRate() {
            return _listenerRate;
        }
        
        @Override
        public Uint32 getProducerElapsedTime() {
            return _producerElapsedTime;
        }
        
        @Override
        public Uint32 getProducerError() {
            return _producerError;
        }
        
        @Override
        public Uint32 getProducerOk() {
            return _producerOk;
        }
        
        @Override
        public Uint32 getProducerRate() {
            return _producerRate;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_listenerElapsedTime);
            result = prime * result + Objects.hashCode(_listenerOk);
            result = prime * result + Objects.hashCode(_listenerRate);
            result = prime * result + Objects.hashCode(_producerElapsedTime);
            result = prime * result + Objects.hashCode(_producerError);
            result = prime * result + Objects.hashCode(_producerOk);
            result = prime * result + Objects.hashCode(_producerRate);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StartTestOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            StartTestOutput other = (StartTestOutput)obj;
            if (!Objects.equals(_listenerElapsedTime, other.getListenerElapsedTime())) {
                return false;
            }
            if (!Objects.equals(_listenerOk, other.getListenerOk())) {
                return false;
            }
            if (!Objects.equals(_listenerRate, other.getListenerRate())) {
                return false;
            }
            if (!Objects.equals(_producerElapsedTime, other.getProducerElapsedTime())) {
                return false;
            }
            if (!Objects.equals(_producerError, other.getProducerError())) {
                return false;
            }
            if (!Objects.equals(_producerOk, other.getProducerOk())) {
                return false;
            }
            if (!Objects.equals(_producerRate, other.getProducerRate())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                StartTestOutputImpl otherImpl = (StartTestOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<StartTestOutput>>, Augmentation<StartTestOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("StartTestOutput");
            CodeHelpers.appendValue(helper, "_listenerElapsedTime", _listenerElapsedTime);
            CodeHelpers.appendValue(helper, "_listenerOk", _listenerOk);
            CodeHelpers.appendValue(helper, "_listenerRate", _listenerRate);
            CodeHelpers.appendValue(helper, "_producerElapsedTime", _producerElapsedTime);
            CodeHelpers.appendValue(helper, "_producerError", _producerError);
            CodeHelpers.appendValue(helper, "_producerOk", _producerOk);
            CodeHelpers.appendValue(helper, "_producerRate", _producerRate);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
