package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Copyright © 2015, 2018 Cisco Systems, Inc. and others. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public 
 * License v1.0 which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <pre>
 * module dsbenchmark {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:dsbenchmark;
 *   prefix dsbenchmark;
 *   revision 2015-01-05 {
 *   }
 *   container test-exec {
 *     list outer-list {
 *       key id;
 *       leaf id {
 *         type int32;
 *       }
 *       choice outer-choice {
 *         case one {
 *           leaf one {
 *             type string;
 *           }
 *         }
 *         case two-three {
 *           leaf two {
 *             type string;
 *           }
 *           leaf three {
 *             type string;
 *           }
 *         }
 *       }
 *       list inner-list {
 *         key name;
 *         leaf name {
 *           type int32;
 *         }
 *         leaf value {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 *   container test-status {
 *     leaf execStatus {
 *       type enumeration {
 *         enum idle {
 *           value 1;
 *         }
 *         enum executing {
 *           value 2;
 *         }
 *       }
 *       config false;
 *     }
 *     leaf testsCompleted {
 *       type uint32;
 *       default 1;
 *     }
 *   }
 *   rpc start-test {
 *     input input {
 *       leaf operation {
 *         type enumeration {
 *           enum PUT {
 *             value 1;
 *           }
 *           enum MERGE {
 *             value 2;
 *           }
 *           enum DELETE {
 *             value 3;
 *           }
 *           enum READ {
 *             value 4;
 *           }
 *         }
 *       }
 *       leaf data-format {
 *         type enumeration {
 *           enum BINDING-AWARE {
 *             value 1;
 *           }
 *           enum BINDING-INDEPENDENT {
 *             value 2;
 *           }
 *         }
 *       }
 *       leaf transaction-type {
 *         type enumeration {
 *           enum SIMPLE-TX {
 *             value 1;
 *           }
 *           enum TX-CHAINING {
 *             value 2;
 *           }
 *         }
 *       }
 *       leaf data-store {
 *         type enumeration {
 *           enum CONFIG {
 *             value 1;
 *           }
 *           enum OPERATIONAL {
 *             value 2;
 *           }
 *           enum BOTH {
 *             value 3;
 *           }
 *         }
 *       }
 *       leaf outerElements {
 *         type uint32;
 *         default 100000;
 *       }
 *       leaf innerElements {
 *         type uint32;
 *         default 1;
 *       }
 *       leaf putsPerTx {
 *         type uint32;
 *         default 1;
 *       }
 *       leaf listeners {
 *         type uint32;
 *         default 0;
 *       }
 *     }
 *     output output {
 *       leaf status {
 *         type enumeration {
 *           enum OK {
 *             value 1;
 *           }
 *           enum FAILED {
 *             value 2;
 *           }
 *           enum TEST-IN-PROGRESS {
 *             value 3;
 *           }
 *         }
 *       }
 *       leaf listBuildTime {
 *         type int64;
 *         units microseconds;
 *       }
 *       leaf execTime {
 *         type int64;
 *         units microseconds;
 *       }
 *       leaf txOk {
 *         type uint32;
 *       }
 *       leaf txError {
 *         type uint32;
 *       }
 *       leaf ntfOk {
 *         type uint32;
 *       }
 *       leaf dataChangeEventsOk {
 *         type uint32;
 *       }
 *     }
 *   }
 *   rpc cleanup-store {
 *   }
 * }
 * </pre>
 *
 */
public interface DsbenchmarkData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec</code> <code>testExec</code>, or <code>null</code> if not present
     */
    @Nullable TestExec getTestExec();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus</code> <code>testStatus</code>, or <code>null</code> if not present
     */
    @Nullable TestStatus getTestStatus();

}

