package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ntfbenchmark</b>
 * <pre>
 * output output {
 *   leaf execStatus {
 *     type enumeration {
 *       enum idle {
 *         value 1;
 *       }
 *       enum executing {
 *         value 2;
 *       }
 *     }
 *   }
 *   leaf ntf-cnt {
 *     type uint32;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ntfbenchmark/test-status/output</i>
 *
 * <p>To create instances of this class use {@link TestStatusOutputBuilder}.
 * @see TestStatusOutputBuilder
 *
 */
public interface TestStatusOutput
    extends
    RpcOutput,
    Augmentable<TestStatusOutput>
{


    public enum ExecStatus implements Enumeration {
        Idle(1, "idle"),
        
        Executing(2, "executing")
        ;
    
        private static final Map<String, ExecStatus> NAME_MAP;
        private static final Map<Integer, ExecStatus> VALUE_MAP;
    
        static {
            final Builder<String, ExecStatus> nb = ImmutableMap.builder();
            final Builder<Integer, ExecStatus> vb = ImmutableMap.builder();
            for (ExecStatus enumItem : ExecStatus.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private ExecStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding ExecStatus item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<ExecStatus> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ExecStatus item, or null if no such item exists
         */
        public static ExecStatus forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.TestStatusOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.TestStatusOutput.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.TestStatusOutput.ExecStatus</code> <code>execStatus</code>, or <code>null</code> if not present
     */
    @Nullable ExecStatus getExecStatus();
    
    /**
     * The number of times the notification benchmark test was invoked
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>ntfCnt</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getNtfCnt();

}

