package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rpcbenchmark</b>
 * <pre>
 * output output {
 *   leaf global-rtc-client-ok {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf global-rtc-client-error {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf exec-time {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf rate {
 *     type uint32;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>rpcbenchmark/start-test/output</i>
 *
 * <p>To create instances of this class use {@link StartTestOutputBuilder}.
 * @see StartTestOutputBuilder
 *
 */
public interface StartTestOutput
    extends
    RpcOutput,
    Augmentable<StartTestOutput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutput.class;
    }
    
    /**
     * Number of successful calls to the Global RPC Server for all test threads
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>globalRtcClientOk</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getGlobalRtcClientOk();
    
    /**
     * Number of failed calls to the Global RPC server from all test threads
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>globalRtcClientError</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getGlobalRtcClientError();
    
    /**
     * Test execution time, in milliseconds
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>execTime</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getExecTime();
    
    /**
     * RPC rate (Number of RPCs/sec)
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>rate</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getRate();

}

