/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.$YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

public interface StartTestInput
extends RpcInput,
Augmentable<StartTestInput> {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    default public Class<StartTestInput> implementedInterface() {
        return StartTestInput.class;
    }

    public static int bindingHashCode(@NonNull StartTestInput obj) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode((Object)obj.getDataFormat());
        result = 31 * result + Objects.hashCode((Object)obj.getDataStore());
        result = 31 * result + Objects.hashCode(obj.getInnerElements());
        result = 31 * result + Objects.hashCode(obj.getListeners());
        result = 31 * result + Objects.hashCode((Object)obj.getOperation());
        result = 31 * result + Objects.hashCode(obj.getOuterElements());
        result = 31 * result + Objects.hashCode(obj.getPutsPerTx());
        result = 31 * result + Objects.hashCode((Object)obj.getTransactionType());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull StartTestInput thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        StartTestInput other = (StartTestInput)CodeHelpers.checkCast(StartTestInput.class, (Object)obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getInnerElements(), other.getInnerElements())) {
            return false;
        }
        if (!Objects.equals(thisObj.getListeners(), other.getListeners())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOuterElements(), other.getOuterElements())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPutsPerTx(), other.getPutsPerTx())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getDataFormat(), (Object)other.getDataFormat())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getDataStore(), (Object)other.getDataStore())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getOperation(), (Object)other.getOperation())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getTransactionType(), (Object)other.getTransactionType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull StartTestInput obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StartTestInput");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"dataFormat", (Object)((Object)obj.getDataFormat()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"dataStore", (Object)((Object)obj.getDataStore()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"innerElements", (Object)obj.getInnerElements());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"listeners", (Object)obj.getListeners());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"operation", (Object)((Object)obj.getOperation()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"outerElements", (Object)obj.getOuterElements());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"putsPerTx", (Object)obj.getPutsPerTx());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"transactionType", (Object)((Object)obj.getTransactionType()));
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public Operation getOperation();

    default public @NonNull Operation requireOperation() {
        return (Operation)((Object)CodeHelpers.require((Object)((Object)this.getOperation()), (String)"operation"));
    }

    public DataFormat getDataFormat();

    default public @NonNull DataFormat requireDataFormat() {
        return (DataFormat)((Object)CodeHelpers.require((Object)((Object)this.getDataFormat()), (String)"dataformat"));
    }

    public TransactionType getTransactionType();

    default public @NonNull TransactionType requireTransactionType() {
        return (TransactionType)((Object)CodeHelpers.require((Object)((Object)this.getTransactionType()), (String)"transactiontype"));
    }

    public DataStore getDataStore();

    default public @NonNull DataStore requireDataStore() {
        return (DataStore)((Object)CodeHelpers.require((Object)((Object)this.getDataStore()), (String)"datastore"));
    }

    public Uint32 getOuterElements();

    default public @NonNull Uint32 requireOuterElements() {
        return (Uint32)CodeHelpers.require((Object)this.getOuterElements(), (String)"outerelements");
    }

    public Uint32 getInnerElements();

    default public @NonNull Uint32 requireInnerElements() {
        return (Uint32)CodeHelpers.require((Object)this.getInnerElements(), (String)"innerelements");
    }

    public Uint32 getPutsPerTx();

    default public @NonNull Uint32 requirePutsPerTx() {
        return (Uint32)CodeHelpers.require((Object)this.getPutsPerTx(), (String)"putspertx");
    }

    public Uint32 getListeners();

    default public @NonNull Uint32 requireListeners() {
        return (Uint32)CodeHelpers.require((Object)this.getListeners(), (String)"listeners");
    }

    public static enum DataFormat implements Enumeration
    {
        BINDINGAWARE(1, "BINDING-AWARE"),
        BINDINGINDEPENDENT(2, "BINDING-INDEPENDENT");

        private final @NonNull String name;
        private final int value;

        private DataFormat(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable DataFormat forName(String name) {
            return switch (name) {
                case "BINDING-AWARE" -> BINDINGAWARE;
                case "BINDING-INDEPENDENT" -> BINDINGINDEPENDENT;
                default -> null;
            };
        }

        public static @Nullable DataFormat forValue(int intValue) {
            return switch (intValue) {
                case 1 -> BINDINGAWARE;
                case 2 -> BINDINGINDEPENDENT;
                default -> null;
            };
        }

        public static @NonNull DataFormat ofName(String name) {
            return (DataFormat)CodeHelpers.checkEnum((Enumeration)DataFormat.forName(name), (String)name);
        }

        public static @NonNull DataFormat ofValue(int intValue) {
            return (DataFormat)CodeHelpers.checkEnum((Enumeration)DataFormat.forValue(intValue), (int)intValue);
        }
    }

    public static enum DataStore implements Enumeration
    {
        CONFIG(1, "CONFIG"),
        OPERATIONAL(2, "OPERATIONAL"),
        BOTH(3, "BOTH");

        private final @NonNull String name;
        private final int value;

        private DataStore(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable DataStore forName(String name) {
            return switch (name) {
                case "CONFIG" -> CONFIG;
                case "OPERATIONAL" -> OPERATIONAL;
                case "BOTH" -> BOTH;
                default -> null;
            };
        }

        public static @Nullable DataStore forValue(int intValue) {
            return switch (intValue) {
                case 1 -> CONFIG;
                case 2 -> OPERATIONAL;
                case 3 -> BOTH;
                default -> null;
            };
        }

        public static @NonNull DataStore ofName(String name) {
            return (DataStore)CodeHelpers.checkEnum((Enumeration)DataStore.forName(name), (String)name);
        }

        public static @NonNull DataStore ofValue(int intValue) {
            return (DataStore)CodeHelpers.checkEnum((Enumeration)DataStore.forValue(intValue), (int)intValue);
        }
    }

    public static enum Operation implements Enumeration
    {
        PUT(1, "PUT"),
        MERGE(2, "MERGE"),
        DELETE(3, "DELETE"),
        READ(4, "READ");

        private final @NonNull String name;
        private final int value;

        private Operation(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable Operation forName(String name) {
            return switch (name) {
                case "PUT" -> PUT;
                case "MERGE" -> MERGE;
                case "DELETE" -> DELETE;
                case "READ" -> READ;
                default -> null;
            };
        }

        public static @Nullable Operation forValue(int intValue) {
            return switch (intValue) {
                case 1 -> PUT;
                case 2 -> MERGE;
                case 3 -> DELETE;
                case 4 -> READ;
                default -> null;
            };
        }

        public static @NonNull Operation ofName(String name) {
            return (Operation)CodeHelpers.checkEnum((Enumeration)Operation.forName(name), (String)name);
        }

        public static @NonNull Operation ofValue(int intValue) {
            return (Operation)CodeHelpers.checkEnum((Enumeration)Operation.forValue(intValue), (int)intValue);
        }
    }

    public static enum TransactionType implements Enumeration
    {
        SIMPLETX(1, "SIMPLE-TX"),
        TXCHAINING(2, "TX-CHAINING");

        private final @NonNull String name;
        private final int value;

        private TransactionType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable TransactionType forName(String name) {
            return switch (name) {
                case "SIMPLE-TX" -> SIMPLETX;
                case "TX-CHAINING" -> TXCHAINING;
                default -> null;
            };
        }

        public static @Nullable TransactionType forValue(int intValue) {
            return switch (intValue) {
                case 1 -> SIMPLETX;
                case 2 -> TXCHAINING;
                default -> null;
            };
        }

        public static @NonNull TransactionType ofName(String name) {
            return (TransactionType)CodeHelpers.checkEnum((Enumeration)TransactionType.forName(name), (String)name);
        }

        public static @NonNull TransactionType ofValue(int intValue) {
            return (TransactionType)CodeHelpers.checkEnum((Enumeration)TransactionType.forValue(intValue), (int)intValue);
        }
    }
}

