/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

public class TestStatusBuilder {
    private TestStatus.ExecStatus _execStatus;
    private Uint32 _testsCompleted;
    Map<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>> augmentation = Map.of();

    public TestStatusBuilder() {
    }

    public TestStatusBuilder(TestStatus base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>>(aug);
        }
        this._execStatus = base.getExecStatus();
        this._testsCompleted = base.getTestsCompleted();
    }

    public static @NonNull TestStatus empty() {
        return LazyEmpty.INSTANCE;
    }

    public TestStatus.ExecStatus getExecStatus() {
        return this._execStatus;
    }

    public Uint32 getTestsCompleted() {
        return this._testsCompleted;
    }

    public <E$$ extends Augmentation<TestStatus>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TestStatusBuilder setExecStatus(TestStatus.ExecStatus value) {
        this._execStatus = value;
        return this;
    }

    public TestStatusBuilder setTestsCompleted(Uint32 value) {
        this._testsCompleted = value;
        return this;
    }

    public TestStatusBuilder addAugmentation(Augmentation<TestStatus> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TestStatusBuilder removeAugmentation(Class<? extends Augmentation<TestStatus>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull TestStatus build() {
        return new TestStatusImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull TestStatus INSTANCE = new TestStatusBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class TestStatusImpl
    extends AbstractAugmentable<TestStatus>
    implements TestStatus {
        private final TestStatus.ExecStatus _execStatus;
        private final Uint32 _testsCompleted;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TestStatusImpl(TestStatusBuilder base) {
            super(base.augmentation);
            this._execStatus = base.getExecStatus();
            this._testsCompleted = base.getTestsCompleted();
        }

        @Override
        public TestStatus.ExecStatus getExecStatus() {
            return this._execStatus;
        }

        @Override
        public Uint32 getTestsCompleted() {
            return this._testsCompleted;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = TestStatus.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return TestStatus.bindingEquals(this, obj);
        }

        public String toString() {
            return TestStatus.bindingToString(this);
        }
    }
}

