/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.ABIVersion;

@Beta
public abstract class AbstractVersionException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ABIVersion closestVersion;
    private final int version;

    AbstractVersionException(String message, short version, ABIVersion closestVersion) {
        super(message);
        this.closestVersion = (ABIVersion)((Object)Preconditions.checkNotNull((Object)((Object)closestVersion)));
        this.version = Short.toUnsignedInt(version);
    }

    public final int getVersion() {
        return this.version;
    }

    @Nonnull
    public final ABIVersion getClosestVersion() {
        return this.closestVersion;
    }
}

