/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequestProxyV1;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
public abstract class AbstractReadPathTransactionRequest<T extends AbstractReadPathTransactionRequest<T>>
extends AbstractReadTransactionRequest<T> {
    private static final long serialVersionUID = 1L;
    private final YangInstanceIdentifier path;

    AbstractReadPathTransactionRequest(TransactionIdentifier identifier, long sequence, ActorRef replyTo, YangInstanceIdentifier path, boolean snapshotOnly) {
        super(identifier, sequence, replyTo, snapshotOnly);
        this.path = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)path);
    }

    AbstractReadPathTransactionRequest(T request, ABIVersion version) {
        super(request, version);
        this.path = ((AbstractReadPathTransactionRequest)request).getPath();
    }

    @Nonnull
    public final YangInstanceIdentifier getPath() {
        return this.path;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("path", (Object)this.path);
    }

    @Override
    protected abstract AbstractReadTransactionRequestProxyV1<T> externalizableProxy(ABIVersion var1);
}

