/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbstractLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

@Beta
public final class CommitLocalTransactionRequest
extends AbstractLocalTransactionRequest<CommitLocalTransactionRequest> {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final DataTreeModification mod;
    private final Exception delayedFailure;
    private final boolean coordinated;

    public CommitLocalTransactionRequest(@Nonnull TransactionIdentifier identifier, long sequence, @Nonnull ActorRef replyTo, @Nonnull DataTreeModification mod, @Nullable Exception delayedFailure, boolean coordinated) {
        super(identifier, sequence, replyTo);
        this.mod = (DataTreeModification)Preconditions.checkNotNull((Object)mod);
        this.delayedFailure = delayedFailure;
        this.coordinated = coordinated;
    }

    public Optional<Exception> getDelayedFailure() {
        return Optional.ofNullable(this.delayedFailure);
    }

    public DataTreeModification getModification() {
        return this.mod;
    }

    public boolean isCoordinated() {
        return this.coordinated;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("coordinated", this.coordinated).add("delayedError", (Object)this.delayedFailure);
    }
}

