/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.ConnectClientFailure;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequestProxyV1;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestProxy;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;

@Beta
public final class ConnectClientRequest
extends Request<ClientIdentifier, ConnectClientRequest> {
    private static final long serialVersionUID = 1L;
    private final ABIVersion minVersion;
    private final ABIVersion maxVersion;

    ConnectClientRequest(ClientIdentifier identifier, long txSequence, ActorRef replyTo, ABIVersion minVersion, ABIVersion maxVersion) {
        super(identifier, txSequence, replyTo);
        this.minVersion = (ABIVersion)((Object)Preconditions.checkNotNull((Object)((Object)minVersion)));
        this.maxVersion = (ABIVersion)((Object)Preconditions.checkNotNull((Object)((Object)maxVersion)));
    }

    public ConnectClientRequest(ClientIdentifier identifier, ActorRef replyTo, ABIVersion minVersion, ABIVersion maxVersion) {
        this(identifier, 0L, replyTo, minVersion, maxVersion);
    }

    private ConnectClientRequest(ConnectClientRequest request, ABIVersion version) {
        super(request, version);
        this.minVersion = request.minVersion;
        this.maxVersion = request.maxVersion;
    }

    public ABIVersion getMinVersion() {
        return this.minVersion;
    }

    public ABIVersion getMaxVersion() {
        return this.maxVersion;
    }

    public ConnectClientFailure toRequestFailure(RequestException cause) {
        return new ConnectClientFailure((ClientIdentifier)this.getTarget(), this.getSequence(), cause);
    }

    @Override
    protected AbstractRequestProxy<ClientIdentifier, ConnectClientRequest> externalizableProxy(ABIVersion version) {
        return new ConnectClientRequestProxyV1(this);
    }

    @Override
    protected ConnectClientRequest cloneAsVersion(ABIVersion version) {
        return new ConnectClientRequest(this, version);
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper addToStringAttributes(@Nonnull MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("minVersion", (Object)this.minVersion).add("maxVersion", (Object)this.maxVersion);
    }
}

