/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccessProxyV1;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;

@Beta
public final class ConnectClientSuccess
extends RequestSuccess<ClientIdentifier, ConnectClientSuccess> {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final List<ActorSelection> alternates;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="See justification above.")
    private final DataTree dataTree;
    private final ActorRef backend;
    private final int maxMessages;

    ConnectClientSuccess(ClientIdentifier target, long sequence, ActorRef backend, List<ActorSelection> alternates, Optional<DataTree> dataTree, int maxMessages) {
        super(target, sequence);
        this.backend = (ActorRef)Preconditions.checkNotNull((Object)backend);
        this.alternates = ImmutableList.copyOf(alternates);
        this.dataTree = dataTree.orElse(null);
        Preconditions.checkArgument((maxMessages > 0 ? 1 : 0) != 0, (String)"Maximum messages has to be positive, not %s", (Object[])new Object[]{maxMessages});
        this.maxMessages = maxMessages;
    }

    public ConnectClientSuccess(@Nonnull ClientIdentifier target, long sequence, @Nonnull ActorRef backend, @Nonnull List<ActorSelection> alternates, @Nonnull DataTree dataTree, int maxMessages) {
        this(target, sequence, backend, alternates, Optional.of(dataTree), maxMessages);
    }

    @Nonnull
    public List<ActorSelection> getAlternates() {
        return this.alternates;
    }

    @Nonnull
    public ActorRef getBackend() {
        return this.backend;
    }

    public Optional<DataTree> getDataTree() {
        return Optional.ofNullable(this.dataTree);
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    @Override
    protected ConnectClientSuccessProxyV1 externalizableProxy(ABIVersion version) {
        return new ConnectClientSuccessProxyV1(this);
    }

    @Override
    protected ConnectClientSuccess cloneAsVersion(ABIVersion version) {
        return this;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("alternates", this.alternates).add("dataTree present", this.getDataTree().isPresent()).add("maxMessages", this.maxMessages);
    }
}

