/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestProxyV1;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

@Beta
public final class ModifyTransactionRequest
extends TransactionRequest<ModifyTransactionRequest> {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final List<TransactionModification> modifications;
    private final PersistenceProtocol protocol;

    ModifyTransactionRequest(TransactionIdentifier target, long sequence, ActorRef replyTo, List<TransactionModification> modifications, PersistenceProtocol protocol) {
        super(target, sequence, replyTo);
        this.modifications = ImmutableList.copyOf(modifications);
        this.protocol = protocol;
    }

    public Optional<PersistenceProtocol> getPersistenceProtocol() {
        return Optional.ofNullable(this.protocol);
    }

    public List<TransactionModification> getModifications() {
        return this.modifications;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("modifications", this.modifications.size()).add("protocol", (Object)this.protocol);
    }

    @Override
    protected ModifyTransactionRequestProxyV1 externalizableProxy(ABIVersion version) {
        return new ModifyTransactionRequestProxyV1(this);
    }

    @Override
    protected ModifyTransactionRequest cloneAsVersion(ABIVersion version) {
        return this;
    }
}

