/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.base.Optional;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.commands.AbstractTransactionSuccessProxy;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class ReadTransactionSuccessProxyV1
extends AbstractTransactionSuccessProxy<ReadTransactionSuccess> {
    private static final long serialVersionUID = 1L;
    private Optional<NormalizedNode<?, ?>> data;

    public ReadTransactionSuccessProxyV1() {
    }

    ReadTransactionSuccessProxyV1(ReadTransactionSuccess request) {
        super(request);
        this.data = request.getData();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.data.isPresent()) {
            out.writeBoolean(true);
            try (NormalizedNodeDataOutput nnout = NormalizedNodeInputOutput.newDataOutput((DataOutput)out);){
                nnout.writeNormalizedNode((NormalizedNode)this.data.get());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.data = in.readBoolean() ? Optional.of((Object)NormalizedNodeInputOutput.newDataInput((DataInput)in).readNormalizedNode()) : Optional.absent();
    }

    @Override
    protected ReadTransactionSuccess createSuccess(TransactionIdentifier target, long sequence) {
        return new ReadTransactionSuccess(target, sequence, this.data);
    }
}

