/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.yangtools.concepts.WritableIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

abstract class AbstractMessageProxy<T extends WritableIdentifier, C extends Message<T, C>>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private T target;
    private long sequence;

    protected AbstractMessageProxy() {
    }

    AbstractMessageProxy(@Nonnull C message) {
        this.target = ((Message)message).getTarget();
        this.sequence = ((Message)message).getSequence();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.target.writeTo((DataOutput)out);
        WritableObjects.writeLong((DataOutput)out, (long)this.sequence);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.target = (WritableIdentifier)Verify.verifyNotNull(this.readTarget(in));
        this.sequence = WritableObjects.readLong((DataInput)in);
    }

    protected final Object readResolve() {
        return Verify.verifyNotNull(this.createMessage(this.target, this.sequence));
    }

    @Nonnull
    protected abstract T readTarget(@Nonnull DataInput var1) throws IOException;

    @Nonnull
    abstract C createMessage(@Nonnull T var1, long var2);
}

