/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.opendaylight.controller.cluster.access.concepts.AbstractEnvelopeProxy;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.yangtools.concepts.Immutable;

public abstract class Envelope<T extends Message<?, ?>>
implements Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final T message;
    private final long txSequence;
    private final long sessionId;

    Envelope(T message, long sessionId, long txSequence) {
        this.message = (Message)Preconditions.checkNotNull(message);
        this.sessionId = sessionId;
        this.txSequence = txSequence;
    }

    public T getMessage() {
        return this.message;
    }

    public long getTxSequence() {
        return this.txSequence;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Envelope.class).add("sessionId", (Object)Long.toHexString(this.sessionId)).add("txSequence", (Object)Long.toHexString(this.txSequence)).add("message", this.message).toString();
    }

    final Object writeReplace() {
        return this.createProxy();
    }

    abstract AbstractEnvelopeProxy<T> createProxy();
}

