/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public final class FrontendIdentifier
implements WritableIdentifier {
    private static final long serialVersionUID = 1L;
    private final MemberName memberName;
    private final FrontendType clientType;

    FrontendIdentifier(MemberName memberName, FrontendType clientType) {
        this.clientType = (FrontendType)Preconditions.checkNotNull((Object)clientType);
        this.memberName = (MemberName)Preconditions.checkNotNull((Object)memberName);
    }

    public static FrontendIdentifier create(MemberName memberName, FrontendType clientType) {
        return new FrontendIdentifier(memberName, clientType);
    }

    public static FrontendIdentifier readFrom(DataInput in) throws IOException {
        MemberName memberName = MemberName.readFrom(in);
        FrontendType clientType = FrontendType.readFrom(in);
        return new FrontendIdentifier(memberName, clientType);
    }

    public void writeTo(DataOutput out) throws IOException {
        this.memberName.writeTo(out);
        this.clientType.writeTo(out);
    }

    public FrontendType getClientType() {
        return this.clientType;
    }

    public MemberName getMemberName() {
        return this.memberName;
    }

    public int hashCode() {
        return Objects.hash(this.memberName, this.clientType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FrontendIdentifier)) {
            return false;
        }
        FrontendIdentifier other = (FrontendIdentifier)obj;
        return this.memberName.equals(other.memberName) && this.clientType.equals(other.clientType);
    }

    public String toPersistentId() {
        return this.memberName.getName() + "-frontend-" + this.clientType.getName();
    }

    public String toString() {
        return this.toPersistentId();
    }

    private Object writeReplace() {
        return new Proxy(this.memberName, this.clientType);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private MemberName memberName;
        private FrontendType clientType;

        public Proxy() {
        }

        Proxy(MemberName memberName, FrontendType clientType) {
            this.memberName = (MemberName)Preconditions.checkNotNull((Object)memberName);
            this.clientType = (FrontendType)Preconditions.checkNotNull((Object)clientType);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.memberName.writeTo(out);
            this.clientType.writeTo(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.memberName = MemberName.readFrom(in);
            this.clientType = FrontendType.readFrom(in);
        }

        private Object readResolve() {
            return new FrontendIdentifier(this.memberName, this.clientType);
        }
    }
}

