/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public final class FrontendType
implements Comparable<FrontendType>,
WritableIdentifier {
    @RegEx
    private static final String SIMPLE_STRING_REGEX = "^[a-zA-Z0-9-_.*+:=,!~';]+$";
    private static final Pattern SIMPLE_STRING_PATTERN = Pattern.compile("^[a-zA-Z0-9-_.*+:=,!~';]+$");
    private static final long serialVersionUID = 1L;
    private final String name;
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The array elements are non-volatile but we don't access them.")
    private volatile byte[] serialized;

    private FrontendType(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    FrontendType(String name, byte[] serialized) {
        this(name);
        this.serialized = (byte[])Verify.verifyNotNull((Object)serialized);
    }

    public static FrontendType forName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)SIMPLE_STRING_PATTERN.matcher(name).matches(), (String)"Supplied name %s does not patch pattern %s", (Object[])new Object[]{name, SIMPLE_STRING_REGEX});
        return new FrontendType(name);
    }

    public static FrontendType readFrom(DataInput in) throws IOException {
        byte[] serialized = new byte[in.readInt()];
        in.readFully(serialized);
        return new FrontendType(new String(serialized, StandardCharsets.UTF_8));
    }

    public void writeTo(DataOutput out) throws IOException {
        byte[] local = this.getSerialized();
        out.writeInt(local.length);
        out.write(local);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof FrontendType && this.name.equals(((FrontendType)obj).name);
    }

    @Override
    public int compareTo(FrontendType obj) {
        return this == obj ? 0 : this.name.compareTo(obj.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(FrontendType.class).add("name", (Object)this.name).toString();
    }

    private byte[] getSerialized() {
        byte[] local = this.serialized;
        if (local == null) {
            this.serialized = local = this.name.getBytes(StandardCharsets.UTF_8);
        }
        return local;
    }

    Object writeReplace() {
        return new Proxy(this.getSerialized());
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private byte[] serialized;

        public Proxy() {
        }

        Proxy(byte[] serialized) {
            this.serialized = (byte[])Preconditions.checkNotNull((Object)serialized);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.serialized.length);
            out.write(this.serialized);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.serialized = new byte[in.readInt()];
            in.readFully(this.serialized);
        }

        private Object readResolve() {
            return new FrontendType(new String(this.serialized, StandardCharsets.UTF_8), this.serialized);
        }
    }
}

