/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.AbstractMessageProxy;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class Message<T extends WritableIdentifier, C extends Message<T, C>>
implements Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ABIVersion version;
    private final long sequence;
    private final T target;

    private Message(ABIVersion version, T target, long sequence) {
        this.target = (WritableIdentifier)Preconditions.checkNotNull(target);
        this.version = (ABIVersion)((Object)Preconditions.checkNotNull((Object)((Object)version)));
        this.sequence = sequence;
    }

    Message(T target, long sequence) {
        this(ABIVersion.current(), target, sequence);
    }

    Message(C msg, ABIVersion version) {
        this(version, ((Message)msg).getTarget(), ((Message)msg).getSequence());
    }

    @Nonnull
    public final T getTarget() {
        return this.target;
    }

    public final long getSequence() {
        return this.sequence;
    }

    @Nonnull
    @VisibleForTesting
    public final ABIVersion getVersion() {
        return this.version;
    }

    @Nonnull
    public final C toVersion(@Nonnull ABIVersion toVersion) {
        if (this.version == toVersion) {
            return (C)this;
        }
        switch (toVersion) {
            case BORON: {
                return (C)((Message)Verify.verifyNotNull(this.cloneAsVersion(toVersion)));
            }
        }
        throw new IllegalArgumentException("Unhandled ABI version " + (Object)((Object)toVersion));
    }

    @Nonnull
    protected abstract C cloneAsVersion(@Nonnull ABIVersion var1);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    @Nonnull
    protected MoreObjects.ToStringHelper addToStringAttributes(@Nonnull MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("target", this.target).add("sequence", (Object)Long.toUnsignedString(this.sequence));
    }

    @Nonnull
    abstract AbstractMessageProxy<T, C> externalizableProxy(@Nonnull ABIVersion var1);

    protected final Object writeReplace() {
        return this.externalizableProxy(this.version);
    }
}

