/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestProxy;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class Request<T extends WritableIdentifier, C extends Request<T, C>>
extends Message<T, C> {
    private static final long serialVersionUID = 1L;
    private final ActorRef replyTo;

    protected Request(@Nonnull T target, long sequence, @Nonnull ActorRef replyTo) {
        super(target, sequence);
        this.replyTo = (ActorRef)Preconditions.checkNotNull((Object)replyTo);
    }

    protected Request(@Nonnull C request, @Nonnull ABIVersion version) {
        super(request, version);
        this.replyTo = (ActorRef)Preconditions.checkNotNull((Object)((Request)request).getReplyTo());
    }

    @Nonnull
    public final ActorRef getReplyTo() {
        return this.replyTo;
    }

    @Nonnull
    public abstract RequestFailure<T, ?> toRequestFailure(@Nonnull RequestException var1);

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("replyTo", (Object)this.replyTo);
    }

    @Override
    protected abstract AbstractRequestProxy<T, C> externalizableProxy(@Nonnull ABIVersion var1);
}

