/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import akka.actor.ActorRef;
import org.opendaylight.controller.cluster.access.concepts.Envelope;
import org.opendaylight.controller.cluster.access.concepts.FailureEnvelope;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelopeProxy;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;

public final class RequestEnvelope
extends Envelope<Request<?, ?>> {
    private static final long serialVersionUID = 1L;

    public RequestEnvelope(Request<?, ?> message, long sessionId, long txSequence) {
        super(message, sessionId, txSequence);
    }

    RequestEnvelopeProxy createProxy() {
        return new RequestEnvelopeProxy(this);
    }

    public void sendFailure(RequestException cause, long executionTimeNanos) {
        this.sendResponse(new FailureEnvelope(((Request)this.getMessage()).toRequestFailure(cause), this.getSessionId(), this.getTxSequence(), executionTimeNanos));
    }

    public void sendSuccess(RequestSuccess<?, ?> success, long executionTimeNanos) {
        this.sendResponse(new SuccessEnvelope(success, this.getSessionId(), this.getTxSequence(), executionTimeNanos));
    }

    private void sendResponse(ResponseEnvelope<?> envelope) {
        ((Request)this.getMessage()).getReplyTo().tell(envelope, ActorRef.noSender());
    }
}

