/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestFailureProxy;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class RequestFailure<T extends WritableIdentifier, C extends RequestFailure<T, C>>
extends Response<T, C> {
    private static final long serialVersionUID = 1L;
    private final RequestException cause;

    protected RequestFailure(@Nonnull C failure, @Nonnull ABIVersion version) {
        super(failure, version);
        this.cause = (RequestException)Preconditions.checkNotNull((Object)((RequestFailure)failure).getCause());
    }

    protected RequestFailure(@Nonnull T target, long sequence, @Nonnull RequestException cause) {
        super(target, sequence);
        this.cause = (RequestException)Preconditions.checkNotNull((Object)cause);
    }

    @Nonnull
    public final RequestException getCause() {
        return this.cause;
    }

    public final boolean isHardFailure() {
        return !this.cause.isRetriable();
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("cause", (Object)this.cause);
    }

    @Override
    protected abstract AbstractRequestFailureProxy<T, C> externalizableProxy(@Nonnull ABIVersion var1);
}

